/*
 * Decompiled with CFR 0.152.
 */
package net.bexla.orevolution.content.data.powers.tools;

import net.bexla.orevolution.content.data.utility.OrevolutionTags;
import net.bexla.orevolution.content.types.OrevolutionToolPower;
import net.bexla.orevolution.content.types.TierProgressRegistry;
import net.bexla.orevolution.content.types.interfaces.Conditional;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.Tags;
import org.jetbrains.annotations.NotNull;

public class ToolIncreaseDrops
extends OrevolutionToolPower {
    private final int dropIncrement;
    private final double chanceMultiplier;
    private final double baseChance;

    public ToolIncreaseDrops(String tooltip_id, Conditional conditional, int dropIncrement, double baseChance, double chanceMultiplier) {
        super(tooltip_id, conditional);
        this.dropIncrement = dropIncrement;
        this.chanceMultiplier = chanceMultiplier;
        this.baseChance = baseChance;
    }

    @Override
    @NotNull
    public Object addTooltipValue() {
        return this.baseChance * 100.0;
    }

    @Override
    public MutableComponent shiftTooltip() {
        return Component.m_237115_((String)("tooltip.orevolution." + this.getTooltipID() + "_explanation"));
    }

    @Override
    public void onMineBlock(ItemStack stack, Level level, BlockPos pos, LivingEntity player, BlockState state) {
        TieredItem tieredItem;
        if (!this.getCondition(stack, state, level, player, null)) {
            return;
        }
        double chance = this.baseChance;
        Item item = stack.m_41720_();
        if (item instanceof TieredItem && TierProgressRegistry.isCorrectTierForDrops((tieredItem = (TieredItem)item).m_43314_(), state)) {
            if (state.m_204336_(OrevolutionTags.Blocks.uncommonDuplicateChance)) {
                chance = this.baseChance / 2.0;
            } else if (state.m_204336_(OrevolutionTags.Blocks.rareDuplicateChance)) {
                chance = this.baseChance / 5.0;
            }
            if (state.m_204336_(Tags.Blocks.ORES)) {
                chance = 0.05;
            }
            if (state.m_204336_(OrevolutionTags.Blocks.alwaysDuplicateChance)) {
                chance = 1.0;
            } else if (state.m_204336_(OrevolutionTags.Blocks.neverDuplicateChance)) {
                chance = 0.0;
            }
            chance *= this.chanceMultiplier;
            if (Math.random() < chance) {
                for (int i = 1; i < this.dropIncrement; ++i) {
                    Block.m_49950_((BlockState)state, (Level)level, (BlockPos)pos);
                }
            }
        }
    }
}

