/*
 * Decompiled with CFR 0.152.
 */
package net.bexla.orevolution.content.data.powers.tools;

import java.util.Iterator;
import java.util.List;
import net.bexla.orevolution.content.data.Conditionals;
import net.bexla.orevolution.content.types.OrevolutionToolPower;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class ToolMultiPower
extends OrevolutionToolPower {
    private final List<OrevolutionToolPower> powers;

    public ToolMultiPower(List<OrevolutionToolPower> powers) {
        super("", Conditionals.always());
        this.powers = powers;
    }

    @Override
    public void onHitEntity(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        for (OrevolutionToolPower p : this.powers) {
            p.onHitEntity(stack, target, attacker);
        }
    }

    @Override
    public void onMineBlock(ItemStack stack, Level level, BlockPos pos, LivingEntity player, BlockState state) {
        for (OrevolutionToolPower p : this.powers) {
            p.onMineBlock(stack, level, pos, player, state);
        }
    }

    @Override
    public void onInventoryTick(ItemStack stack, Level level, Entity entity, int slot, boolean selected) {
        for (OrevolutionToolPower p : this.powers) {
            p.onInventoryTick(stack, level, entity, slot, selected);
        }
    }

    @Override
    public List<Component> appendTooltip(ItemStack stack, Level level, List<Component> lines) {
        Iterator<OrevolutionToolPower> iterator = this.powers.iterator();
        if (iterator.hasNext()) {
            OrevolutionToolPower p = iterator.next();
            return p.appendTooltip(stack, level, lines);
        }
        return List.of();
    }
}

