/*
 * Decompiled with CFR 0.152.
 */
package net.bexla.orevolution.content.types.item.modeled;

import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.bexla.orevolution.content.models.ReinforcedNetheriteChestplateModel;
import net.bexla.orevolution.content.models.ReinforcedNetheriteLeggingsModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import org.jetbrains.annotations.NotNull;

public class ReinforcedArmor
extends ArmorItem {
    public ReinforcedArmor(ArmorMaterial mat, ArmorItem.Type type, Item.Properties properties) {
        super(mat, type, properties);
    }

    @Nullable
    public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
        if (slot == EquipmentSlot.CHEST) {
            return "orevolution:textures/models/armor/reinforced_netherite_chestplate.png";
        }
        if (slot == EquipmentSlot.LEGS) {
            return "orevolution:textures/models/armor/reinforced_netherite_leggings.png";
        }
        return super.getArmorTexture(stack, entity, slot, type);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        super.initializeClient(consumer);
        consumer.accept(new IClientItemExtensions(){

            @NotNull
            public HumanoidModel<?> getHumanoidArmorModel(LivingEntity livingEntity, ItemStack stack, EquipmentSlot slot, HumanoidModel<?> original) {
                if (slot == EquipmentSlot.CHEST) {
                    return new ReinforcedNetheriteChestplateModel(ReinforcedNetheriteChestplateModel.createBodyLayer().m_171564_());
                }
                if (slot == EquipmentSlot.LEGS) {
                    return new ReinforcedNetheriteLeggingsModel(ReinforcedNetheriteLeggingsModel.createBodyLayer().m_171564_());
                }
                return original;
            }
        });
    }
}

