/*
 * Decompiled with CFR 0.152.
 */
package net.bexla.orevolution.content.types.providers;

import com.teamabnormals.blueprint.core.data.client.BlueprintBlockStateProvider;
import java.util.function.Supplier;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;

public abstract class BlockStateModelProvider
extends BlueprintBlockStateProvider {
    public BlockStateModelProvider(PackOutput output, ExistingFileHelper help) {
        super(output, "orevolution", help);
    }

    protected ResourceLocation texture(String name) {
        return this.modLoc("block/" + name);
    }

    protected String name(Supplier<? extends Block> block) {
        return BlockStateModelProvider.name((Block)block.get());
    }

    public void simpleBlock(Supplier<? extends Block> block, String subfolder) {
        this.simpleBlock(block.get(), this.cubeAll(block.get(), subfolder));
    }

    public ModelFile cubeAll(Block block, String subfolder) {
        return this.models().cubeAll(BlockStateModelProvider.name((Block)block), this.blockTexture(block, subfolder));
    }

    public void doorBlock(Supplier<? extends Block> door) {
        Block block = door.get();
        if (block instanceof DoorBlock) {
            DoorBlock doorBlock = (DoorBlock)block;
            this.doorBlock(doorBlock, BlockStateModelProvider.suffix((ResourceLocation)this.blockTexture(block, "decorative/door"), (String)"_bottom"), BlockStateModelProvider.suffix((ResourceLocation)this.blockTexture(block, "decorative/door"), (String)"_top"));
            this.generatedItem((ItemLike)block, "item/blockitem");
        }
    }

    public void trapdoorBlock(Supplier<? extends Block> trapdoor) {
        Block block = trapdoor.get();
        if (block instanceof TrapDoorBlock) {
            TrapDoorBlock trapDoorBlock = (TrapDoorBlock)block;
            this.trapdoorBlock(trapDoorBlock, this.blockTexture(block, "decorative/trapdoor"), true);
        }
    }

    public ResourceLocation blockTexture(Block block, String subfolder) {
        ResourceLocation name = this.key(block);
        return new ResourceLocation(name.m_135827_(), "block/" + subfolder + "/" + name.m_135815_());
    }

    private ResourceLocation key(Block block) {
        return ForgeRegistries.BLOCKS.getKey((Object)block);
    }

    public void stairsBlock(Supplier<? extends Block> block, Supplier<? extends Block> fullBlock) {
        Block block2 = block.get();
        if (block2 instanceof StairBlock) {
            StairBlock block1 = (StairBlock)block2;
            this.stairsBlock(block1, this.blockTexture(fullBlock.get(), "decorative"));
        }
    }

    public void slabBlock(Supplier<? extends Block> block, Supplier<? extends Block> fullBlock) {
        Block block2 = block.get();
        if (block2 instanceof SlabBlock) {
            SlabBlock block1 = (SlabBlock)block2;
            this.slabBlock(block1, this.texture(this.name(fullBlock)), this.blockTexture(fullBlock.get(), "decorative"));
        }
    }

    public void wallBlock(Supplier<? extends Block> wall, Supplier<? extends Block> fullBlock) {
        Block block = wall.get();
        if (block instanceof WallBlock) {
            WallBlock block2 = (WallBlock)block;
            this.wallBlock(block2, this.blockTexture(fullBlock.get(), "decorative"));
        }
    }

    public ModelFile cubeBottomTop(Supplier<? extends Block> block, String subfolder) {
        BlockModelBuilder model = (BlockModelBuilder)this.models().getBuilder(this.name(block));
        model.parent((ModelFile)this.models().getExistingFile(new ResourceLocation("minecraft", "block/cube_bottom_top")));
        model.texture("top", BlockStateModelProvider.suffix((ResourceLocation)this.blockTexture(block.get(), subfolder), (String)"_top"));
        model.texture("bottom", BlockStateModelProvider.suffix((ResourceLocation)this.blockTexture(block.get(), subfolder), (String)"_bottom"));
        model.texture("side", BlockStateModelProvider.suffix((ResourceLocation)this.blockTexture(block.get(), subfolder), (String)"_side"));
        return model;
    }

    public ModelFile directionalBlockModel(Supplier<? extends Block> block, String name, String side, String front, String back, String top) {
        return ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(name, "block/observer")).texture("bottom", this.texture(back))).texture("side", this.texture(side))).texture("top", this.texture(top))).texture("front", this.texture(front))).texture("particle", this.texture(front));
    }
}

