/*
 * Decompiled with CFR 0.152.
 */
package net.bexla.orevolution.mixins;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.bexla.orevolution.OrevolutionConfig;
import net.bexla.orevolution.content.data.utility.OrevolutionTags;
import net.bexla.orevolution.content.types.TierProgressRegistry;
import net.bexla.orevolution.content.types.ToolPowerRegistry;
import net.bexla.orevolution.content.types.interfaces.ToolPower;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Item.class})
public class ItemMixin {
    @Inject(method={"appendHoverText"}, at={@At(value="TAIL")})
    private void orevolution$injectPowerTooltip(ItemStack stack, @Nullable Level level, List<Component> lines, TooltipFlag flag, CallbackInfo ci) {
        Item item = stack.m_41720_();
        if (item instanceof TieredItem) {
            ToolPower power;
            String return_string;
            TieredItem tieredItem = (TieredItem)item;
            Tier tier = tieredItem.m_43314_();
            String string = return_string = TierProgressRegistry.isTierSorted(tier) ? TierProgressRegistry.getName(tier).m_135815_() : ItemMixin.isCorrectTierVanilla(tier);
            if (TierProgressRegistry.getAssociatedTierFromSecondary(tier) != null) {
                return_string = TierProgressRegistry.getName(TierProgressRegistry.getAssociatedTierFromSecondary(tier)).m_135815_();
            }
            if (stack.m_204117_(OrevolutionTags.Items.tinProgFollow) && !stack.m_204117_(OrevolutionTags.Items.tinProgExcept) && !((Boolean)OrevolutionConfig.CLIENT.tinProgTip.get()).booleanValue()) {
                return_string = "tin";
            } else if (stack.m_204117_(OrevolutionTags.Items.platProgFollow) && !stack.m_204117_(OrevolutionTags.Items.platProgExcept) && !((Boolean)OrevolutionConfig.CLIENT.platProgTip.get()).booleanValue()) {
                return_string = "platinum";
            }
            ArrayList<Object> tip = new ArrayList<Object>();
            if (tieredItem instanceof SwordItem && ((Boolean)OrevolutionConfig.CLIENT.weaponsPowersTip.get()).booleanValue()) {
                ToolPower power2 = ToolPowerRegistry.getSwordPowerForTier(tier);
                if (power2 != null) {
                    tip.addAll(power2.appendTooltip(stack, level, lines));
                }
            } else if (tieredItem instanceof DiggerItem && ((Boolean)OrevolutionConfig.CLIENT.weaponsPowersTip.get()).booleanValue() && (power = ToolPowerRegistry.getToolPowerForTier(tier)) != null) {
                tip.addAll(power.appendTooltip(stack, level, lines));
            }
            if (((Boolean)OrevolutionConfig.CLIENT.harvestTip.get()).booleanValue() && !return_string.isEmpty()) {
                if (!tip.isEmpty()) {
                    tip.add(Component.m_237113_((String)""));
                }
                tip.add(Component.m_237115_((String)"tooltip.orevolution.harvest_tier"));
                tip.add(Component.m_237113_((String)(" - " + Component.m_237115_((String)("tiers.orevolution." + return_string.toLowerCase())).getString())).m_130940_(ChatFormatting.YELLOW));
            }
            lines.addAll(1, tip);
        }
    }

    private static String isCorrectTierVanilla(Tier tier) {
        int i = tier.m_6604_();
        return switch (i) {
            case 1 -> "wood";
            case 2 -> "tin";
            case 3 -> "platinum";
            case 4 -> "diamond";
            default -> "netherite";
        };
    }

    @Inject(method={"inventoryTick"}, at={@At(value="HEAD")})
    private void orevolution$injectInventoryTick(ItemStack stack, Level level, Entity entity, int slotIndex, boolean selectedIndex, CallbackInfo cir) {
        Item item = stack.m_41720_();
        if (item instanceof TieredItem) {
            ToolPower power;
            TieredItem tieredItem = (TieredItem)item;
            Tier tier = tieredItem.m_43314_();
            if (tieredItem instanceof SwordItem) {
                if (!((Boolean)OrevolutionConfig.COMMON.weaponsPowers.get()).booleanValue()) {
                    return;
                }
                power = ToolPowerRegistry.getSwordPowerForTier(tier);
                power.onInventoryTick(stack, level, entity, slotIndex, selectedIndex);
            }
            if (stack.m_41720_() instanceof DiggerItem) {
                if (!((Boolean)OrevolutionConfig.COMMON.toolsPowers.get()).booleanValue()) {
                    return;
                }
                power = ToolPowerRegistry.getToolPowerForTier(tier);
                power.onInventoryTick(stack, level, entity, slotIndex, selectedIndex);
            }
        }
    }
}

