/*
 * Decompiled with CFR 0.152.
 */
package net.bexla.orevolution.mixins;

import java.util.Map;
import java.util.function.Supplier;
import net.bexla.orevolution.OrevolutionConfig;
import net.bexla.orevolution.content.types.ToolPowerRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ItemStack.class})
public class ItemstackMixin {
    private static final Map<Tier, Supplier<Integer>> BALANCED_DURABILITIES = Map.of(Tiers.IRON, OrevolutionConfig.COMMON.ironMaxUses, Tiers.DIAMOND, OrevolutionConfig.COMMON.diamondMaxUses, Tiers.GOLD, OrevolutionConfig.COMMON.goldMaxUses, Tiers.NETHERITE, OrevolutionConfig.COMMON.netheriteMaxUses, Tiers.STONE, OrevolutionConfig.COMMON.stoneMaxUses, Tiers.WOOD, OrevolutionConfig.COMMON.woodMaxUses);

    @Inject(method={"mineBlock"}, at={@At(value="HEAD")})
    private void orevolution$injectPowerMining(Level level, BlockState state, BlockPos pos, Player entity, CallbackInfo cir) {
        ItemStack stack = (ItemStack)this;
        Item item = stack.m_41720_();
        if (item instanceof TieredItem) {
            TieredItem tieredItem = (TieredItem)item;
            if (tieredItem instanceof SwordItem) {
                if (!((Boolean)OrevolutionConfig.COMMON.weaponsPowers.get()).booleanValue()) {
                    return;
                }
                power = ToolPowerRegistry.getSwordPowerForTier(tieredItem.m_43314_());
                if (power == null) {
                    return;
                }
                power.onMineBlock(stack, level, pos, (LivingEntity)entity, state);
            } else if (tieredItem instanceof DiggerItem) {
                if (!((Boolean)OrevolutionConfig.COMMON.toolsPowers.get()).booleanValue()) {
                    return;
                }
                power = ToolPowerRegistry.getToolPowerForTier(tieredItem.m_43314_());
                if (power == null) {
                    return;
                }
                power.onMineBlock(stack, level, pos, (LivingEntity)entity, state);
            }
        }
    }

    @Inject(method={"hurtEnemy"}, at={@At(value="HEAD")})
    private void orevolution$injectPowerAttackEnemy(LivingEntity target, Player attacker, CallbackInfo cir) {
        ItemStack stack = (ItemStack)this;
        Item item = stack.m_41720_();
        if (item instanceof TieredItem) {
            TieredItem tieredItem = (TieredItem)item;
            if (tieredItem instanceof SwordItem) {
                if (!((Boolean)OrevolutionConfig.COMMON.weaponsPowers.get()).booleanValue()) {
                    return;
                }
                power = ToolPowerRegistry.getSwordPowerForTier(tieredItem.m_43314_());
                if (power == null) {
                    return;
                }
                power.onHitEntity(stack, target, (LivingEntity)attacker);
            } else if (tieredItem instanceof DiggerItem) {
                if (!((Boolean)OrevolutionConfig.COMMON.toolsPowers.get()).booleanValue()) {
                    return;
                }
                power = ToolPowerRegistry.getToolPowerForTier(tieredItem.m_43314_());
                if (power == null) {
                    return;
                }
                power.onHitEntity(stack, target, (LivingEntity)attacker);
            }
        }
    }

    @Inject(method={"getMaxDamage"}, at={@At(value="RETURN")}, cancellable=true)
    private void orevolution$injectModifierMaxUses(CallbackInfoReturnable<Integer> cir) {
        ItemStack stack = (ItemStack)this;
        int uses = (Integer)cir.getReturnValue();
        Item item = stack.m_41720_();
        if (!(item instanceof TieredItem)) {
            return;
        }
        TieredItem tiered = (TieredItem)item;
        Supplier<Integer> override = BALANCED_DURABILITIES.get(tiered.m_43314_());
        if (override != null) {
            uses = override.get();
        }
        if (tiered instanceof SwordItem && ((Boolean)OrevolutionConfig.COMMON.weaponsPowers.get()).booleanValue()) {
            uses = ToolPowerRegistry.getSwordPowerForTier(tiered.m_43314_()).setMaxUses(stack, uses);
        } else if (tiered instanceof DiggerItem && ((Boolean)OrevolutionConfig.COMMON.toolsPowers.get()).booleanValue()) {
            uses = ToolPowerRegistry.getToolPowerForTier(tiered.m_43314_()).setMaxUses(stack, uses);
        }
        cir.setReturnValue((Object)uses);
    }
}

