package fun.wich;

import net.minecraft.class_10179;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1341;
import net.minecraft.class_1347;
import net.minecraft.class_1353;
import net.minecraft.class_1361;
import net.minecraft.class_1374;
import net.minecraft.class_1376;
import net.minecraft.class_1391;
import net.minecraft.class_1394;
import net.minecraft.class_1429;
import net.minecraft.class_1538;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3542;
import net.minecraft.class_3730;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_4538;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5147;
import net.minecraft.class_5712;
import net.minecraft.class_5819;
import net.minecraft.class_7;
import net.minecraft.class_7995;
import net.minecraft.entity.*;
import net.minecraft.entity.ai.goal.*;
import net.minecraft.entity.passive.*;
import net.minecraft.world.*;
import java.util.UUID;
import java.util.function.IntFunction;

public class CluckshroomEntity extends class_1429 implements class_5147 {
	public static final class_4048 BABY_BASE_DIMENSIONS = CluckshroomMod.CLUCKSHROOM.method_18386().method_18383(0.5F).method_55685(0.2975F);
	public static final class_2940<Integer> VARIANT = class_2945.method_12791(CluckshroomEntity.class, class_2943.field_13327);
	public static final int MUTATION_CHANCE = 1024;
	public static final boolean DEFAULT_HAS_JOCKEY = false;
	public static final int EGG_DELAY = 6000;
	public static final int MUSHROOM_DELAY = 6000;
	public float flapProgress;
	public float maxWingDeviation;
	public float lastMaxWingDeviation;
	public float lastFlapProgress;
	public float flapSpeed = 1.0F;
	private float field_28639 = 1.0F;
	public int eggLayTime;
	public int mushroomPlantTime;
	public boolean hasJockey = DEFAULT_HAS_JOCKEY;
	private UUID lightningId;
	public CluckshroomEntity(class_1299<? extends CluckshroomEntity> entityType, class_1937 world) {
		super(entityType, world);
		this.eggLayTime = this.field_5974.method_43048(EGG_DELAY) + EGG_DELAY;
		this.mushroomPlantTime = this.field_5974.method_43048(MUSHROOM_DELAY) + MUSHROOM_DELAY;
		this.method_5941(class_7.field_18, 0.0F);
	}
	@Override
	public float method_6144(class_2338 pos, class_4538 world) {
		return world.method_8320(pos.method_10074()).method_27852(class_2246.field_10402) ? 10.0F : world.method_42309(pos);
	}
	@Override
	protected void method_5959() {
		this.field_6201.method_6277(0, new class_1347(this));
		this.field_6201.method_6277(1, new class_1374(this, 1.4));
		this.field_6201.method_6277(2, new class_1341(this, 1.0F));
		this.field_6201.method_6277(3, new class_1391(this, 1.0F, (stack) -> stack.method_31573(CluckshroomMod.TAG_CLUCKSHROOM_FOOD), false));
		this.field_6201.method_6277(4, new class_1353(this, 1.1));
		this.field_6201.method_6277(5, new class_1394(this, 1.0F));
		this.field_6201.method_6277(6, new class_1361(this, class_1657.class, 6.0F));
		this.field_6201.method_6277(7, new class_1376(this));
	}
	@Override
	public class_4048 method_55694(class_4050 pose) {
		return this.method_6109() ? BABY_BASE_DIMENSIONS : super.method_55694(pose);
	}
	public static class_5132.class_5133 createCluckshroomAttributes() {
		return class_1429.method_61457().method_26868(class_5134.field_23716, 4.0F).method_26868(class_5134.field_23719, 0.25F);
	}
	public static boolean canSpawn(class_1299<CluckshroomEntity> ignoredType, class_1936 world, class_3730 ignoredSpawnReason, class_2338 pos, class_5819 ignoredRandom) {
		return world.method_8320(pos.method_10074()).method_26164(CluckshroomMod.TAG_CLUCKSHROOMS_SPAWNABLE_ON) && method_39448(world, pos);
	}
	@Override
	public void method_5800(class_3218 world, class_1538 lightning) {
		UUID uUID = lightning.method_5667();
		if (!uUID.equals(this.lightningId)) {
			this.setVariant(this.getVariant() == Variant.RED ? Variant.BROWN : Variant.RED);
			this.lightningId = uUID;
			this.method_5783(CluckshroomMod.ENTITY_CLUCKSHROOM_CONVERT, 2.0F, 1.0F);
		}
	}
	@Override
	public class_1269 method_5992(class_1657 player, class_1268 hand) {
		class_1799 itemStack = player.method_5998(hand);
		if (itemStack.method_31574(class_1802.field_8868) && this.method_27072()) {
			if (this.method_5770() instanceof class_3218 serverWorld) {
				this.method_6636(serverWorld, class_3419.field_15248, itemStack);
				this.method_32875(class_5712.field_28730, player);
				itemStack.method_7970(1, player, method_56079(hand));
			}
			return class_1269.field_5812;
		}
		else return super.method_5992(player, hand);
	}
	@Override
	public void method_6636(class_3218 world, class_3419 shearedSoundCategory, class_1799 shears) {
		world.method_43129(null, this, CluckshroomMod.ENTITY_CLUCKSHROOM_SHEAR, shearedSoundCategory, 1, 1);
		this.method_29243(class_1299.field_6132, class_10179.method_63607(this, false, false), (chicken) -> {
			world.method_65096(class_2398.field_11236, this.method_23317(), this.method_23323(0.5F), this.method_23321(), 1, 0, 0, 0, 0);
			this.method_61419(world, CluckshroomMod.CLUCKSHROOM_SHEARING, shears, (worldx, stack) -> {
				for (int i = 0; i < stack.method_7947(); ++i) {
					worldx.method_8649(new class_1542(this.method_5770(), this.method_23317(), this.method_23323(1), this.method_23321(), stack.method_46651(1)));
				}
			});
		});
	}
	@Override public boolean method_27072() { return this.method_5805() && !this.method_6109(); }
	@Override
	public void method_6007() {
		super.method_6007();
		this.lastFlapProgress = this.flapProgress;
		this.lastMaxWingDeviation = this.maxWingDeviation;
		this.maxWingDeviation += (this.method_24828() ? -1.0F : 4.0F) * 0.3F;
		this.maxWingDeviation = class_3532.method_15363(this.maxWingDeviation, 0.0F, 1.0F);
		if (!this.method_24828() && this.flapSpeed < 1.0F) this.flapSpeed = 1.0F;
		this.flapSpeed *= 0.9F;
		class_243 vec3d = this.method_18798();
		if (!this.method_24828() && vec3d.field_1351 < (double)0.0F) this.method_18799(vec3d.method_18805(1.0F, 0.6, 1.0F));
		this.flapProgress += this.flapSpeed * 2.0F;
		class_1937 world = this.method_5770();
		if (world instanceof class_3218 serverWorld) {
			if (this.method_5805() && !this.method_6109() && !this.hasJockey()) {
				if (--this.eggLayTime <= 0) {
					if (this.method_64169(serverWorld, CluckshroomMod.CLUCKSHROOM_LAY_GAMEPLAY, this::method_5775)) {
						this.method_5783(CluckshroomMod.ENTITY_CLUCKSHROOM_EGG, 1.0F, (this.field_5974.method_43057() - this.field_5974.method_43057()) * 0.2F + 1.0F);
						this.method_32876(class_5712.field_28738);
					}
					this.eggLayTime = this.field_5974.method_43048(EGG_DELAY) + EGG_DELAY;
				}
				if (--this.mushroomPlantTime <= 0) {
					class_2338 pos = this.method_24515();
					class_2680 mushroom = getVariant().getMushroomState();
					if (mushroom.method_26184(world, pos)) {
						this.method_5783(CluckshroomMod.ENTITY_CLUCKSHROOM_MUSHROOM, 1.0F, (this.field_5974.method_43057() - this.field_5974.method_43057()) * 0.2F + 1.0F);
						world.method_8652(pos, mushroom, class_2248.field_31028);
						this.method_32876(class_5712.field_28738);
					}
					this.mushroomPlantTime = this.field_5974.method_43048(MUSHROOM_DELAY) + MUSHROOM_DELAY;
				}
			}
		}
	}
	@Override protected boolean method_5776() { return this.field_28627 > this.field_28639; }
	@Override protected void method_5801() { this.field_28639 = this.field_28627 + this.maxWingDeviation / 2.0F; }
	@Override protected class_3414 method_5994() { return CluckshroomMod.ENTITY_CLUCKSHROOM_AMBIENT; }
	@Override protected class_3414 method_6011(class_1282 source){ return CluckshroomMod.ENTITY_CLUCKSHROOM_HURT; }
	@Override protected class_3414 method_6002(){ return CluckshroomMod.ENTITY_CLUCKSHROOM_DEATH; }
	@Override
	protected void method_5712(class_2338 pos, class_2680 state) {
		this.method_5783(CluckshroomMod.ENTITY_CLUCKSHROOM_STEP, 0.15F, 1.0F);
	}
	@Override
	public CluckshroomEntity method_5613(class_3218 serverWorld, class_1296 passiveEntity) {
		CluckshroomEntity entity = CluckshroomMod.CLUCKSHROOM.method_5883(serverWorld, class_3730.field_16466);
		if (entity != null) entity.setVariant(passiveEntity instanceof CluckshroomEntity other ? this.chooseBabyVariant(other) : getVariant());
		return entity;
	}
	protected Variant chooseBabyVariant(CluckshroomEntity other) {
		Variant variant = this.getVariant();
		Variant variant2 = other.getVariant();
		if (variant == variant2 && this.field_5974.method_43048(MUTATION_CHANCE) == 0) return variant == Variant.BROWN ? Variant.RED : Variant.BROWN;
		else return this.field_5974.method_43056() ? variant : variant2;
	}
	@Override public boolean method_6481(class_1799 stack) { return stack.method_31573(CluckshroomMod.TAG_CLUCKSHROOM_FOOD); }
	@Override
	protected int method_6110(class_3218 world) {
		return this.hasJockey() ? 10 : super.method_6110(world);
	}
	@Override
	protected void method_5693(class_2945.class_9222 builder) {
		super.method_5693(builder);
		builder.method_56912(VARIANT, Variant.DEFAULT.index);
	}
	@Override
	public void method_5749(class_2487 view) {
		super.method_5749(view);
		this.hasJockey = view.method_68566("IsChickenJockey", false);
		view.method_10550("EggLayTime").ifPresent((eggLayTime) -> this.eggLayTime = eggLayTime);
		view.method_10550("MushroomPlantTime").ifPresent((mushroomPlantTime) -> this.mushroomPlantTime = mushroomPlantTime);
		this.setVariant(Variant.fromIndex(view.method_68083("Type", 0)));
	}
	@Override
	public void method_5652(class_2487 view) {
		super.method_5652(view);
		view.method_10556("IsChickenJockey", this.hasJockey);
		view.method_10569("EggLayTime", this.eggLayTime);
		view.method_10569("MushroomPlantTime", this.mushroomPlantTime);
		view.method_10569("Type", this.getVariant().getIndex());
	}
	public void setVariant(Variant variant) { this.field_6011.method_12778(VARIANT, variant.index); }
	public Variant getVariant() { return Variant.fromIndex(this.field_6011.method_12789(VARIANT)); }
	@Override public boolean method_5974(double distanceSquared) { return this.hasJockey(); }
	@Override
	protected void method_5865(class_1297 passenger, class_1297.class_4738 positionUpdater) {
		super.method_5865(passenger, positionUpdater);
		if (passenger instanceof class_1309 livingEntity) livingEntity.field_6283 = this.field_6283;
	}
	public boolean hasJockey() { return this.hasJockey; }
	public void setHasJockey(boolean hasJockey) { this.hasJockey = hasJockey; }
	public enum Variant implements class_3542 {
		RED("red", 0, class_2246.field_10559.method_9564()),
		BROWN("brown", 1, class_2246.field_10251.method_9564());
		public static final Variant DEFAULT = RED;
		private static final IntFunction<Variant> INDEX_MAPPER = class_7995.method_47914(Variant::getIndex, values(), class_7995.class_7996.field_41666);
		private final String name;
		private final int index;
		private final class_2680 mushroom;
		Variant(final String name, final int index, final class_2680 mushroom) {
			this.name = name;
			this.index = index;
			this.mushroom = mushroom;
		}
		public class_2680 getMushroomState() { return this.mushroom; }
		public String method_15434() { return this.name; }
		public int getIndex() { return this.index; }
		static Variant fromIndex(int index) { return INDEX_MAPPER.apply(index); }
	}
}
