package fun.wich.client;

import com.google.common.collect.Maps;
import fun.wich.CluckshroomEntity;
import fun.wich.CluckshroomMod;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_156;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5617;
import net.minecraft.class_927;
import java.util.Map;

@Environment(EnvType.CLIENT)
public class CluckshroomEntityRenderer extends class_927<CluckshroomEntity, CluckshroomEntityRenderState, CluckshroomEntityModel> {
	protected final CluckshroomEntityModel adultModel;
	protected final CluckshroomEntityModel babyModel;
	private static final Map<CluckshroomEntity.Variant, class_2960> TEXTURES = class_156.method_654(Maps.newHashMap(), (map) -> {
		map.put(CluckshroomEntity.Variant.BROWN, class_2960.method_60655(CluckshroomMod.MOD_ID, "textures/entity/cluckshroom/cluckshroom_brown.png"));
		map.put(CluckshroomEntity.Variant.RED, class_2960.method_60655(CluckshroomMod.MOD_ID, "textures/entity/cluckshroom/cluckshroom_red.png"));
	});
	public CluckshroomEntityRenderer(class_5617.class_5618 context) {
		super(context, new CluckshroomEntityModel(context.method_32167(CluckshroomClient.CLUCKSHROOM)), 0.3F);
		this.adultModel = this.field_4737;
		this.babyModel = new CluckshroomEntityModel(context.method_32167(CluckshroomClient.CLUCKSHROOM_BABY));
	}
	@Override
	public void render(CluckshroomEntityRenderState chickenEntityRenderState, class_4587 matrixStack, class_4597 orderedRenderCommandQueue, int i) {
		this.field_4737 = chickenEntityRenderState.field_53457 ? babyModel : adultModel;
		super.method_4054(chickenEntityRenderState, matrixStack, orderedRenderCommandQueue, i);
	}
	@Override
	public class_2960 getTexture(CluckshroomEntityRenderState chickenEntityRenderState) {
		return TEXTURES.get(chickenEntityRenderState.type);
	}
	@Override public CluckshroomEntityRenderState method_55269() { return new CluckshroomEntityRenderState(); }
	@Override
	public void updateRenderState(CluckshroomEntity entity, CluckshroomEntityRenderState state, float f) {
		super.method_62355(entity, state, f);
		state.field_53301 = class_3532.method_16439(f, entity.lastFlapProgress, entity.flapProgress);
		state.field_53302 = class_3532.method_16439(f, entity.lastMaxWingDeviation, entity.maxWingDeviation);
		state.type = entity.getVariant();
	}
}