package fun.wich.client;

import com.google.common.collect.Maps;
import fun.wich.CluckshroomEntity;
import fun.wich.CluckshroomMod;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_156;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_558;
import net.minecraft.class_5617;
import net.minecraft.class_927;
import java.util.Map;

@Environment(EnvType.CLIENT)
public class CluckshroomEntityRenderer extends class_927<CluckshroomEntity, class_558<CluckshroomEntity>> {
	private static final Map<CluckshroomEntity.Variant, class_2960> TEXTURES = class_156.method_654(Maps.newHashMap(), (map) -> {
		map.put(CluckshroomEntity.Variant.BROWN, class_2960.method_60655(CluckshroomMod.MOD_ID, "textures/entity/cluckshroom/cluckshroom_brown.png"));
		map.put(CluckshroomEntity.Variant.RED, class_2960.method_60655(CluckshroomMod.MOD_ID, "textures/entity/cluckshroom/cluckshroom_red.png"));
	});
	public CluckshroomEntityRenderer(class_5617.class_5618 context) {
		super(context, new CluckshroomEntityModel(context.method_32167(CluckshroomClient.CLUCKSHROOM)), 0.3F);
	}
	@Override public class_2960 getTexture(CluckshroomEntity state) { return TEXTURES.get(state.getVariant()); }
	@Override
	protected float getAnimationProgress(CluckshroomEntity chickenEntity, float f) {
		float g = class_3532.method_16439(f, chickenEntity.lastFlapProgress, chickenEntity.flapProgress);
		float h = class_3532.method_16439(f, chickenEntity.lastMaxWingDeviation, chickenEntity.maxWingDeviation);
		return (class_3532.method_15374(g) + 1.0F) * h;
	}
}