/*
 * Decompiled with CFR 0.152.
 */
package io.github.thevoidblock.customnames;

import io.github.thevoidblock.customnames.CustomNames;
import io.github.thevoidblock.customnames.CustomNamesConfig;
import me.shedaniel.autoconfig.AutoConfig;
import net.fabricmc.fabric.api.client.message.v1.ClientReceiveMessageEvents;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_5250;
import net.minecraft.class_7417;

public class ChatModifier {
    public static void register() {
        ClientReceiveMessageEvents.ALLOW_GAME.register((message, overlay) -> {
            CustomNamesConfig config = (CustomNamesConfig)AutoConfig.getConfigHolder(CustomNamesConfig.class).getConfig();
            if (!config.enabled || !config.chatModification) {
                return true;
            }
            return ChatModifier.attemptRawTranslatableChatModification(message, config);
        });
        ClientReceiveMessageEvents.ALLOW_CHAT.register((message, signedMessage, sender, params, receptionTimestamp) -> {
            CustomNamesConfig config = (CustomNamesConfig)AutoConfig.getConfigHolder(CustomNamesConfig.class).getConfig();
            if (!config.enabled || !config.chatModification) {
                return true;
            }
            if (sender == null) {
                return ChatModifier.attemptRawTranslatableChatModification(message, config);
            }
            class_2561 name = class_2561.method_30163((String)sender.name());
            if (CustomNames.checkNameModification(config, name)) {
                return ChatModifier.modifyMessage((messageText, messageContent) -> {
                    assert (CustomNames.CLIENT.field_1724 != null);
                    ChatModifier.addModifiedMessage(CustomNames.getAppliedName(config, name), messageText);
                    return true;
                }, message);
            }
            return true;
        });
    }

    private static boolean modifyMessage(MessageModifier modifier, class_2561 message) {
        class_2588 messageContent;
        class_7417 class_74172 = message.method_10851();
        if (class_74172 instanceof class_2588 && (messageContent = (class_2588)class_74172).method_11022().equals("chat.type.text") && messageContent.method_11023().length == 2) {
            class_2561 messageText;
            Object messageTextObject = messageContent.method_11023()[1];
            if (messageTextObject instanceof class_2561) {
                messageText = (class_2561)messageTextObject;
            } else if (messageTextObject instanceof String) {
                messageText = class_2561.method_30163((String)((String)messageTextObject));
            } else {
                return true;
            }
            return !modifier.modify(messageText, messageContent);
        }
        return true;
    }

    private static void addModifiedMessage(class_2561 player, class_2561 message) {
        ((class_5250)player).method_27693("*");
        CustomNames.CLIENT.field_1705.method_1743().method_1812((class_2561)class_2561.method_43469((String)"chat.type.text", (Object[])new Object[]{player, ((class_5250)message).method_27693(" ")}));
    }

    private static boolean attemptRawTranslatableChatModification(class_2561 message, CustomNamesConfig config) {
        return ChatModifier.modifyMessage((messageText, messageContent) -> {
            class_2561 name = class_2561.method_30163((String)messageContent.method_29434(0).getString());
            if (CustomNames.checkNameModification(config, name)) {
                assert (CustomNames.CLIENT.field_1724 != null);
                ChatModifier.addModifiedMessage(CustomNames.getAppliedName(config, name), messageText);
                return true;
            }
            return false;
        }, message);
    }

    @FunctionalInterface
    private static interface MessageModifier {
        public boolean modify(class_2561 var1, class_2588 var2);
    }
}

