/*
 * Decompiled with CFR 0.152.
 */
package echotrace.adventure.text.minimessage.tag.standard;

import echotrace.adventure.text.Component;
import echotrace.adventure.text.TranslatableComponent;
import echotrace.adventure.text.TranslationArgument;
import echotrace.adventure.text.format.StyleBuilderApplicable;
import echotrace.adventure.text.minimessage.Context;
import echotrace.adventure.text.minimessage.ParsingException;
import echotrace.adventure.text.minimessage.internal.serializer.Emitable;
import echotrace.adventure.text.minimessage.internal.serializer.SerializableResolver;
import echotrace.adventure.text.minimessage.tag.Tag;
import echotrace.adventure.text.minimessage.tag.resolver.ArgumentQueue;
import echotrace.adventure.text.minimessage.tag.resolver.TagResolver;
import echotrace.adventure.text.minimessage.tag.standard.StandardTags;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Nullable;

final class TranslatableFallbackTag {
    private static final String TR_OR = "tr_or";
    private static final String TRANSLATE_OR = "translate_or";
    private static final String LANG_OR = "lang_or";
    static final TagResolver RESOLVER = SerializableResolver.claimingComponent(StandardTags.names("lang_or", "translate_or", "tr_or"), TranslatableFallbackTag::create, TranslatableFallbackTag::claim);

    private TranslatableFallbackTag() {
    }

    static Tag create(ArgumentQueue args, Context ctx) throws ParsingException {
        List with;
        String key = args.popOr("A translation key is required").value();
        String fallback = args.popOr("A fallback messages is required").value();
        if (args.hasNext()) {
            with = new ArrayList();
            while (args.hasNext()) {
                with.add(ctx.deserialize(args.pop().value()));
            }
        } else {
            with = Collections.emptyList();
        }
        return Tag.inserting(Component.translatable(key, fallback, with, new StyleBuilderApplicable[0]));
    }

    @Nullable
    static Emitable claim(Component input) {
        if (!(input instanceof TranslatableComponent) || ((TranslatableComponent)input).fallback() == null) {
            return null;
        }
        TranslatableComponent tr = (TranslatableComponent)input;
        return emit -> {
            emit.tag(LANG_OR);
            emit.argument(tr.key());
            emit.argument(tr.fallback());
            for (TranslationArgument with : tr.arguments()) {
                emit.argument(with.asComponent());
            }
        };
    }
}

