/*
 * Decompiled with CFR 0.152.
 */
package echotrace.colorparser;

import echotrace.adventure.text.Component;
import echotrace.adventure.text.ComponentLike;
import echotrace.adventure.text.minimessage.MiniMessage;
import echotrace.adventure.text.minimessage.tag.resolver.Placeholder;
import echotrace.adventure.text.minimessage.tag.resolver.TagResolver;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.clip.placeholderapi.PlaceholderAPI;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.intellij.lang.annotations.Subst;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public class ColorParser {
    private static final MiniMessage MINIMESSAGE = MiniMessage.miniMessage();
    private static final Pattern LEGACY_REGEX = Pattern.compile("[\u00a7&][0-9a-fk-or]");
    private static final Map<String, String> LEGACY_TO_MINIMESSAGE = new HashMap<String, String>();
    private final List<TagResolver> minimessagePlaceholders = new ArrayList<TagResolver>();
    private String text;

    private ColorParser() {
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    public ColorParser(String text) {
        this.setText(text);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    @NotNull
    public static ColorParser text(String text) {
        return ColorParser.of(text);
    }

    @NotNull
    public static ColorParser of(String text) {
        return new ColorParser().setText(text);
    }

    @NotNull
    public Component build() {
        return MINIMESSAGE.deserialize(this.getText(), this.minimessagePlaceholders.toArray(new TagResolver[0]));
    }

    @NotNull
    public ColorParser parseLegacy() {
        String textParsed = this.getText();
        @NotNull Matcher matcher = LEGACY_REGEX.matcher(textParsed);
        while (matcher.find()) {
            String match = matcher.group();
            textParsed = textParsed.replace(match, LEGACY_TO_MINIMESSAGE.getOrDefault(match, match));
        }
        this.setText(textParsed);
        return this;
    }

    @NotNull
    public ColorParser parsePAPIPlaceholders(@NotNull Player p) {
        if (Bukkit.getServer().getPluginManager().isPluginEnabled("PlaceholderAPI")) {
            this.setText(PlaceholderAPI.setPlaceholders((Player)p, (String)this.getText()));
        }
        return this;
    }

    @NotNull
    public ColorParser parsePAPIPlaceholders(@NotNull OfflinePlayer p) {
        if (Bukkit.getServer().getPluginManager().isPluginEnabled("PlaceholderAPI")) {
            this.setText(PlaceholderAPI.setPlaceholders((OfflinePlayer)p, (String)this.getText()));
        }
        return this;
    }

    @NotNull
    public ColorParser parsePAPIPlaceholdersRelational(@NotNull Player p, @NotNull Player p2) {
        if (Bukkit.getServer().getPluginManager().isPluginEnabled("PlaceholderAPI")) {
            this.setText(PlaceholderAPI.setRelationalPlaceholders((Player)p, (Player)p2, (String)this.getText()));
        }
        return this;
    }

    @NotNull
    public ColorParser parsePAPIPlaceholdersBracket(@NotNull Player p) {
        if (Bukkit.getServer().getPluginManager().isPluginEnabled("PlaceholderAPI")) {
            this.setText(PlaceholderAPI.setBracketPlaceholders((Player)p, (String)this.getText()));
        }
        return this;
    }

    @NotNull
    public ColorParser parsePAPIPlaceholdersBracket(@NotNull OfflinePlayer p) {
        if (Bukkit.getServer().getPluginManager().isPluginEnabled("PlaceholderAPI")) {
            this.setText(PlaceholderAPI.setBracketPlaceholders((OfflinePlayer)p, (String)this.getText()));
        }
        return this;
    }

    @NotNull
    public ColorParser parseMinimessagePlaceholder(@Subst(value="test_placeholder") @NotNull String placeholder, String value) {
        this.minimessagePlaceholders.add(Placeholder.component(placeholder, ColorParser.of(value).parseLegacy().build()));
        return this;
    }

    @NotNull
    public ColorParser parseMinimessagePlaceholder(@Subst(value="test_placeholder") @NotNull String placeholder, @NotNull ComponentLike value) {
        this.minimessagePlaceholders.add(Placeholder.component(placeholder, value));
        return this;
    }

    @NotNull
    public ColorParser parseStringPlaceholder(@NotNull String placeholder, @NotNull String value) {
        this.setText(this.getText().replaceAll(placeholder, value));
        return this;
    }

    public String toString() {
        return this.getText();
    }

    private String getText() {
        return this.text;
    }

    @NotNull
    private ColorParser setText(String text) {
        this.text = text;
        return this;
    }

    static {
        LEGACY_TO_MINIMESSAGE.put("\u00a70", "<black>");
        LEGACY_TO_MINIMESSAGE.put("\u00a71", "<dark_blue>");
        LEGACY_TO_MINIMESSAGE.put("\u00a72", "<dark_green>");
        LEGACY_TO_MINIMESSAGE.put("\u00a73", "<dark_aqua>");
        LEGACY_TO_MINIMESSAGE.put("\u00a74", "<dark_red>");
        LEGACY_TO_MINIMESSAGE.put("\u00a75", "<dark_purple>");
        LEGACY_TO_MINIMESSAGE.put("\u00a76", "<gold>");
        LEGACY_TO_MINIMESSAGE.put("\u00a77", "<gray>");
        LEGACY_TO_MINIMESSAGE.put("\u00a78", "<dark_gray>");
        LEGACY_TO_MINIMESSAGE.put("\u00a79", "<blue>");
        LEGACY_TO_MINIMESSAGE.put("\u00a7a", "<green>");
        LEGACY_TO_MINIMESSAGE.put("\u00a7b", "<aqua>");
        LEGACY_TO_MINIMESSAGE.put("\u00a7c", "<red>");
        LEGACY_TO_MINIMESSAGE.put("\u00a7d", "<light_purple>");
        LEGACY_TO_MINIMESSAGE.put("\u00a7e", "<yellow>");
        LEGACY_TO_MINIMESSAGE.put("\u00a7f", "<white>");
        LEGACY_TO_MINIMESSAGE.put("\u00a7k", "<obfuscated>");
        LEGACY_TO_MINIMESSAGE.put("\u00a7l", "<bold>");
        LEGACY_TO_MINIMESSAGE.put("\u00a7m", "<strikethrough>");
        LEGACY_TO_MINIMESSAGE.put("\u00a7n", "<underlined>");
        LEGACY_TO_MINIMESSAGE.put("\u00a7o", "<italic>");
        LEGACY_TO_MINIMESSAGE.put("\u00a7r", "<reset>");
        LEGACY_TO_MINIMESSAGE.put("&0", "<black>");
        LEGACY_TO_MINIMESSAGE.put("&1", "<dark_blue>");
        LEGACY_TO_MINIMESSAGE.put("&2", "<dark_green>");
        LEGACY_TO_MINIMESSAGE.put("&3", "<dark_aqua>");
        LEGACY_TO_MINIMESSAGE.put("&4", "<dark_red>");
        LEGACY_TO_MINIMESSAGE.put("&5", "<dark_purple>");
        LEGACY_TO_MINIMESSAGE.put("&6", "<gold>");
        LEGACY_TO_MINIMESSAGE.put("&7", "<gray>");
        LEGACY_TO_MINIMESSAGE.put("&8", "<dark_gray>");
        LEGACY_TO_MINIMESSAGE.put("&9", "<blue>");
        LEGACY_TO_MINIMESSAGE.put("&a", "<green>");
        LEGACY_TO_MINIMESSAGE.put("&b", "<aqua>");
        LEGACY_TO_MINIMESSAGE.put("&c", "<red>");
        LEGACY_TO_MINIMESSAGE.put("&d", "<light_purple>");
        LEGACY_TO_MINIMESSAGE.put("&e", "<yellow>");
        LEGACY_TO_MINIMESSAGE.put("&f", "<white>");
        LEGACY_TO_MINIMESSAGE.put("&k", "<obfuscated>");
        LEGACY_TO_MINIMESSAGE.put("&l", "<bold>");
        LEGACY_TO_MINIMESSAGE.put("&m", "<strikethrough>");
        LEGACY_TO_MINIMESSAGE.put("&n", "<underlined>");
        LEGACY_TO_MINIMESSAGE.put("&o", "<italic>");
        LEGACY_TO_MINIMESSAGE.put("&r", "<reset>");
    }
}

