/*
 * Decompiled with CFR 0.152.
 */
package echotrace.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.LongArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.tree.LiteralCommandNode;
import echotrace.commands.subcommands.ReloadCommand;
import echotrace.commands.subcommands.TraceCommand;
import echotrace.config.Config;
import echotrace.depend.VanishPlugins;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import io.papermc.paper.command.brigadier.argument.ArgumentTypes;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class CommandManager {
    public static LiteralCommandNode<CommandSourceStack> echotrace() {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"echotrace").then(CommandManager.reload())).then(CommandManager.traceSub())).build();
    }

    private static LiteralArgumentBuilder<CommandSourceStack> reload() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"reload").requires(src -> src.getSender().hasPermission("echotrace.reload"))).executes(ReloadCommand::execute);
    }

    public static LiteralCommandNode<CommandSourceStack> trace() {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"trace").requires(src -> src.getExecutor() instanceof Player)).then(CommandManager.entityTraceArgs())).then(CommandManager.playerTraceArgs())).then(CommandManager.positionTraceArgs())).then(CommandManager.blockTraceArgs())).then(CommandManager.cancelTraceArgs())).build();
    }

    private static LiteralArgumentBuilder<CommandSourceStack> traceSub() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"trace").requires(src -> src.getExecutor() instanceof Player)).then(CommandManager.entityTraceArgs())).then(CommandManager.playerTraceArgs())).then(CommandManager.positionTraceArgs())).then(CommandManager.blockTraceArgs())).then(CommandManager.cancelTraceArgs());
    }

    private static LiteralArgumentBuilder<CommandSourceStack> entityTraceArgs() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"entity").requires(src -> src.getSender().hasPermission("echotrace.trace.entities"))).then(((RequiredArgumentBuilder)Commands.argument((String)"entity", (ArgumentType)ArgumentTypes.entities()).then(Commands.argument((String)"points", (ArgumentType)IntegerArgumentType.integer(1)).executes(ctx -> TraceCommand.executeEntity(ctx, true)))).executes(ctx -> TraceCommand.executeEntity(ctx, false)));
    }

    private static LiteralArgumentBuilder<CommandSourceStack> playerTraceArgs() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"player").requires(src -> src.getSender().hasPermission("echotrace.trace.players"))).then(((RequiredArgumentBuilder)Commands.argument((String)"player", (ArgumentType)StringArgumentType.word()).suggests((ctx, b) -> {
            for (Player p : Bukkit.getOnlinePlayers()) {
                if (VanishPlugins.isVanished(p)) continue;
                b.suggest(p.getName());
            }
            return b.buildFuture();
        }).then(Commands.argument((String)"points", (ArgumentType)IntegerArgumentType.integer(1)).executes(ctx -> TraceCommand.executePlayer(ctx, true)))).executes(ctx -> TraceCommand.executePlayer(ctx, false)));
    }

    private static LiteralArgumentBuilder<CommandSourceStack> positionTraceArgs() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"position").requires(src -> src.getSender().hasPermission("echotrace.trace.positions"))).then(((RequiredArgumentBuilder)Commands.argument((String)"position", (ArgumentType)ArgumentTypes.finePosition((boolean)true)).then(Commands.argument((String)"points", (ArgumentType)IntegerArgumentType.integer(1)).executes(ctx -> TraceCommand.executePosition(ctx, true)))).executes(ctx -> TraceCommand.executePosition(ctx, false)));
    }

    private static LiteralArgumentBuilder<CommandSourceStack> blockTraceArgs() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"block").requires(src -> src.getSender().hasPermission("echotrace.trace.blocks"))).then(((RequiredArgumentBuilder)Commands.argument((String)"type", (ArgumentType)ArgumentTypes.blockState()).then(((RequiredArgumentBuilder)Commands.argument((String)"radius", (ArgumentType)DoubleArgumentType.doubleArg(0.0, Math.max(1.0, Config.max_radius))).then(((RequiredArgumentBuilder)Commands.argument((String)"limit", (ArgumentType)LongArgumentType.longArg(1L)).then(Commands.argument((String)"points", (ArgumentType)LongArgumentType.longArg(1L)).executes(ctx -> TraceCommand.executeBlock(ctx, true, true, true)))).executes(ctx -> TraceCommand.executeBlock(ctx, true, true, false)))).executes(ctx -> TraceCommand.executeBlock(ctx, true, false, false)))).executes(ctx -> TraceCommand.executeBlock(ctx, false, false, false)));
    }

    private static LiteralArgumentBuilder<CommandSourceStack> cancelTraceArgs() {
        return (LiteralArgumentBuilder)Commands.literal((String)"cancel").executes(TraceCommand::cancel);
    }
}

