/*
 * Decompiled with CFR 0.152.
 */
package echotrace.core;

import echotrace.config.Config;
import echotrace.core.TraceRenderer;
import echotrace.core.target.Target;
import echotrace.util.TraceUtils;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.util.Vector;

public class Trace {
    private Player player;
    private Target target;
    private Location currentLocation;
    private Vector currentDirection;
    private long maxPoints;
    private long rendered;
    private boolean hit;

    private Trace() {
    }

    public Trace(Player player, Target target, long points) {
        this.player = player;
        this.target = target;
        this.currentLocation = player.getEyeLocation();
        this.currentDirection = player.getEyeLocation().getDirection().normalize();
        this.maxPoints = points;
        this.rendered = 0L;
        this.hit = false;
    }

    public Player getPlayer() {
        return this.player;
    }

    public Location getCurrentLocation() {
        return this.currentLocation;
    }

    public Target getTarget() {
        return this.target;
    }

    public Vector getCurrentDirection() {
        return this.currentDirection;
    }

    public void advance(long times) {
        for (long i = 0L; i < times && (this.maxPoints <= 0L || this.rendered < this.maxPoints); ++i) {
            if (this.arrived()) {
                TraceRenderer.queueRender(this.player, this.currentLocation, true);
                ++this.rendered;
                this.hit = true;
                break;
            }
            Vector toTarget = this.target.getLocation().toVector().subtract(this.currentLocation.toVector());
            Vector targetDirection = toTarget.clone().normalize();
            Vector newDirection = Config.turn_rate <= 0.0 ? targetDirection : TraceUtils.turnTowards(this.currentDirection, targetDirection);
            Location newLocation = this.currentLocation.clone().add(newDirection.clone().multiply(Config.tracing_step_size));
            TraceRenderer.queueRender(this.player, newLocation, false);
            ++this.rendered;
            this.currentDirection = newDirection;
            this.currentLocation = newLocation;
        }
    }

    public boolean arrived() {
        Vector toTarget = this.target.getLocation().toVector().subtract(this.currentLocation.toVector());
        return toTarget.lengthSquared() < 0.25;
    }

    public boolean active() {
        return this.currentLocation.getWorld() == this.target.getLocation().getWorld() && !this.hit && (this.maxPoints <= 0L || this.rendered < this.maxPoints);
    }
}

