/*
 * Decompiled with CFR 0.152.
 */
package echotrace.core;

import com.github.Anon8281.universalScheduler.scheduling.tasks.MyScheduledTask;
import echotrace.Main;
import echotrace.config.Config;
import echotrace.core.Trace;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class TraceManager {
    private static MyScheduledTask heartbeat = null;
    private static final List<Trace> activeTraces = new ArrayList<Trace>();

    public static void startHeartbeat() {
        if (heartbeat != null) {
            heartbeat.cancel();
            heartbeat = null;
        }
        long interval = Math.max(1L, Config.tracing_interval);
        heartbeat = Main.getScheduler().runTaskTimerAsynchronously(TraceManager::advanceTraces, interval, interval);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void advanceTraces() {
        if (Bukkit.getServer().getTPS()[0] < Config.min_tps) {
            return;
        }
        List<Trace> list = activeTraces;
        synchronized (list) {
            activeTraces.removeIf(trace -> !trace.active());
            for (Trace trace2 : activeTraces) {
                trace2.advance(Config.tracing_count);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerTrace(Trace trace) {
        List<Trace> list = activeTraces;
        synchronized (list) {
            activeTraces.add(trace);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unregisterTracesFrom(Player player) {
        List<Trace> list = activeTraces;
        synchronized (list) {
            activeTraces.removeIf(trace -> trace.getPlayer().getUniqueId() == player.getUniqueId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unregisterAllTraces() {
        List<Trace> list = activeTraces;
        synchronized (list) {
            activeTraces.clear();
        }
    }
}

