/*
 * Decompiled with CFR 0.152.
 */
package echotrace.listeners;

import echotrace.Main;
import echotrace.adventure.text.Component;
import echotrace.adventure.text.TextComponent;
import echotrace.adventure.text.event.ClickEvent;
import echotrace.adventure.text.event.HoverEvent;
import echotrace.adventure.text.format.NamedTextColor;
import echotrace.adventure.text.format.TextColor;
import echotrace.colorparser.ColorParser;
import echotrace.config.Config;
import echotrace.util.UpdateChecker;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;

public class UpdateNotifyListener
implements Listener {
    private final UpdateChecker updateChecker;

    public UpdateNotifyListener(UpdateChecker updateChecker) {
        this.updateChecker = updateChecker;
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        if (player.hasPermission("echotrace.update-notify") && this.updateChecker.isUpdateAvailable()) {
            Component prefix = ColorParser.of(Config.prefix).parsePAPIPlaceholders(player).parseLegacy().build();
            Object message = ((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().append(prefix)).append((Component)Component.text("A new version of ", (TextColor)NamedTextColor.GREEN))).append((Component)Component.text(this.updateChecker.getResourceName(), (TextColor)NamedTextColor.GOLD))).append((Component)Component.text(" is available: ", (TextColor)NamedTextColor.GREEN))).append((Component)Component.text("v" + this.updateChecker.getLatestVersion(), (TextColor)NamedTextColor.GOLD))).appendNewline()).append((Component)((TextComponent)Component.text(this.updateChecker.getUpdateLink(), (TextColor)NamedTextColor.GRAY).clickEvent(ClickEvent.openUrl(this.updateChecker.getUpdateLink()))).hoverEvent(HoverEvent.showText(Component.text("Click to open this link in your browser", (TextColor)NamedTextColor.GRAY))))).build();
            Main.getAdventure().player(player).sendMessage((Component)message);
        }
    }
}

