/*
 * Decompiled with CFR 0.152.
 */
package echotrace.util;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import echotrace.Main;
import echotrace.adventure.text.Component;
import echotrace.adventure.text.TextComponent;
import echotrace.adventure.text.format.NamedTextColor;
import echotrace.adventure.text.format.TextColor;
import echotrace.config.Config;
import echotrace.util.Logger;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.Bukkit;

public class UpdateChecker {
    private volatile boolean updateAvailable = false;
    private String updateLink = null;
    private String latestVer = null;
    private final String currentVersion;
    private final String resourceName;
    private final String projectId;
    private final Gson gson;

    public UpdateChecker(String resourceName, String projectId, String currentVersion) {
        this.currentVersion = currentVersion;
        this.resourceName = resourceName;
        this.projectId = projectId;
        this.gson = new Gson();
    }

    private void checkForUpdates() {
        Main.getScheduler().runTaskAsynchronously(() -> {
            try {
                String line;
                URL url = new URL("https://api.modrinth.com/v2/project/" + this.projectId + "/version");
                HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                conn.setRequestProperty("User-Agent", "EchoTrace Update Checker");
                conn.setRequestMethod("GET");
                BufferedReader reader = new BufferedReader(new InputStreamReader(conn.getInputStream()));
                StringBuilder jsonBuilder = new StringBuilder();
                while ((line = reader.readLine()) != null) {
                    jsonBuilder.append(line);
                }
                reader.close();
                JsonArray versions = this.gson.fromJson(jsonBuilder.toString(), JsonArray.class);
                if (versions.isEmpty()) {
                    Logger.logErr("No versions for resource with id '" + this.projectId + "' found on Modrinth!");
                    return;
                }
                JsonObject latest = versions.get(0).getAsJsonObject();
                String latestVersion = latest.get("version_number").getAsString();
                if (UpdateChecker.isNewerVersion(this.currentVersion, latestVersion)) {
                    this.updateAvailable = true;
                    this.latestVer = latestVersion;
                    this.updateLink = "https://modrinth.com/plugin/" + this.projectId + "/version/latest";
                    Object message = ((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().append((Component)Component.text("[EchoTrace] Update available!", (TextColor)NamedTextColor.GRAY))).appendNewline()).append((Component)Component.text(" "))).appendNewline()).append((Component)Component.text("  A new version of ", (TextColor)NamedTextColor.GREEN))).append((Component)Component.text(this.resourceName, (TextColor)NamedTextColor.GOLD))).append((Component)Component.text(" is available: ", (TextColor)NamedTextColor.GREEN))).append((Component)Component.text("v" + latestVersion, (TextColor)NamedTextColor.GOLD))).appendNewline()).append((Component)Component.text("  Please update at your earliest convenience to prevent known issues.", (TextColor)NamedTextColor.DARK_GREEN))).appendNewline()).append((Component)Component.text("  https://modrinth.com/plugin/" + this.projectId + "/version/latest", (TextColor)NamedTextColor.GRAY))).appendNewline()).append((Component)Component.text(" "))).build();
                    Main.getAdventure().console().sendMessage((Component)message);
                } else {
                    Bukkit.getLogger().log(Level.INFO, "[EchoTrace] You are running the latest version of " + this.resourceName + " (v" + this.currentVersion + ")!");
                }
            }
            catch (Exception e) {
                Logger.logErr("Failed to check for updates: " + e.getMessage());
            }
        });
    }

    public UpdateChecker checkEveryXHours(int hours) {
        int ticks = hours * 60 * 60 * 20;
        Main.getScheduler().runTaskTimerAsynchronously(this::checkForUpdates, ticks, ticks);
        return this;
    }

    public UpdateChecker checkNow() {
        this.checkForUpdates();
        return this;
    }

    private static boolean isNewerVersion(String currentVersion, String latestVersion) {
        String latSuffix;
        String current = UpdateChecker.extractMainVersion(currentVersion);
        String latest = UpdateChecker.extractMainVersion(latestVersion);
        String[] currentParts = current.split("\\.");
        String[] latestParts = latest.split("\\.");
        int length = Math.max(currentParts.length, latestParts.length);
        for (int i = 0; i < length; ++i) {
            int lat;
            int curr = i < currentParts.length ? Integer.parseInt(currentParts[i]) : 0;
            int n = lat = i < latestParts.length ? Integer.parseInt(latestParts[i]) : 0;
            if (lat > curr) {
                return true;
            }
            if (lat >= curr) continue;
            return false;
        }
        String currSuffix = UpdateChecker.extractSuffix(currentVersion);
        if (currSuffix.equals(latSuffix = UpdateChecker.extractSuffix(latestVersion))) {
            return false;
        }
        if (currSuffix.isEmpty() && !latSuffix.isEmpty()) {
            return false;
        }
        if (!currSuffix.isEmpty() && latSuffix.isEmpty()) {
            return true;
        }
        if (Config.releases_only) {
            return false;
        }
        if (currSuffix.startsWith("dev") && latSuffix.startsWith("pre")) {
            return true;
        }
        if (currSuffix.startsWith("pre") && latSuffix.startsWith("dev")) {
            return false;
        }
        int currNum = UpdateChecker.extractSuffixNumber(currSuffix);
        int latNum = UpdateChecker.extractSuffixNumber(latSuffix);
        return latNum > currNum;
    }

    private static String extractMainVersion(String input) {
        Pattern pattern = Pattern.compile("(\\d+)(\\.\\d+){0,3}");
        Matcher matcher = pattern.matcher(input);
        if (matcher.find()) {
            return matcher.group();
        }
        return "0";
    }

    private static String extractSuffix(String version) {
        Matcher m = Pattern.compile("\\d+\\.\\d+(?:\\.\\d+)?(?:[-_]?([a-zA-Z]+\\d*))?").matcher(version);
        return m.find() && m.group(1) != null ? m.group(1).toLowerCase() : "";
    }

    private static int extractSuffixNumber(String suffix) {
        Matcher m = Pattern.compile("\\d+").matcher(suffix);
        return m.find() ? Integer.parseInt(m.group()) : 0;
    }

    public boolean isUpdateAvailable() {
        return this.updateAvailable;
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public String getUpdateLink() {
        return this.updateLink;
    }

    public String getLatestVersion() {
        return this.latestVer;
    }
}

