/*
 * Decompiled with CFR 0.152.
 */
package echotrace;

import com.github.Anon8281.universalScheduler.UniversalScheduler;
import com.github.Anon8281.universalScheduler.scheduling.schedulers.TaskScheduler;
import com.tchristofferson.configupdater.ConfigUpdater;
import echotrace.adventure.platform.bukkit.BukkitAudiences;
import echotrace.bukkit.Metrics;
import echotrace.commands.CommandManager;
import echotrace.config.Config;
import echotrace.config.Lang;
import echotrace.core.TraceManager;
import echotrace.core.TraceRenderer;
import echotrace.listeners.UpdateNotifyListener;
import echotrace.util.Logger;
import echotrace.util.UpdateChecker;
import io.papermc.paper.command.brigadier.Commands;
import io.papermc.paper.plugin.lifecycle.event.types.LifecycleEventType;
import io.papermc.paper.plugin.lifecycle.event.types.LifecycleEvents;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public final class Main
extends JavaPlugin {
    private static Main instance;
    private static List<String> languages;
    private static BukkitAudiences adventure;
    private static TaskScheduler scheduler;

    public void onLoad() {
        instance = this;
        languages = new ArrayList<String>();
    }

    public void onEnable() {
        adventure = BukkitAudiences.create((Plugin)this);
        scheduler = UniversalScheduler.getScheduler((Plugin)this);
        this.saveDefaultConfig();
        File configFile = new File(this.getDataFolder(), "config.yml");
        try {
            ConfigUpdater.update((Plugin)this, "config.yml", configFile, new String[0]);
        }
        catch (IOException e) {
            Logger.logErr(e);
        }
        this.reloadConfig();
        Config.load(this.getConfig());
        File languageDir = new File(this.getDataFolder(), "language");
        if (!languageDir.exists()) {
            languageDir.mkdirs();
        }
        try (JarFile jar = new JarFile(this.getFile());){
            Enumeration<JarEntry> entries = jar.entries();
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                if (!entry.getName().startsWith("language/") || !entry.getName().endsWith(".yml")) continue;
                String langFileName = entry.getName().replace("language/", "");
                languages.add(langFileName);
                if (!new File(languageDir, langFileName).exists()) {
                    this.saveResource("language/" + langFileName, false);
                }
                ConfigUpdater.update((Plugin)this, "language/" + langFileName, new File(languageDir, langFileName), new String[0]);
            }
        }
        catch (IOException e) {
            Logger.logErr("Failed to update language files: " + e.getMessage());
            Logger.logErr(e);
        }
        File languageFile = new File(languageDir, Config.language + ".yml");
        if (!languageFile.exists()) {
            Logger.logErr("Language " + Config.language + " doesn't exist in your language folder! Defaulting to English (en).");
            languageFile = new File(languageDir, "en.yml");
            if (!languageFile.exists()) {
                this.saveResource("language/en.yml", false);
            }
        }
        YamlConfiguration languageConfig = YamlConfiguration.loadConfiguration((File)languageFile);
        Lang.load((FileConfiguration)languageConfig);
        this.getLifecycleManager().registerEventHandler((LifecycleEventType)LifecycleEvents.COMMANDS, event -> {
            ((Commands)event.registrar()).register(CommandManager.echotrace(), List.of("et"));
            ((Commands)event.registrar()).register(CommandManager.trace());
        });
        TraceManager.startHeartbeat();
        TraceRenderer.startHeartbeat();
        UpdateChecker updateChecker = new UpdateChecker("EchoTrace", "echotrace", this.getDescription().getVersion()).checkNow();
        if (Config.update_check_interval > 0) {
            updateChecker.checkEveryXHours(Config.update_check_interval);
        }
        Bukkit.getPluginManager().registerEvents((Listener)new UpdateNotifyListener(updateChecker), (Plugin)this);
        Metrics metrics = new Metrics(this, 27144);
    }

    public void onDisable() {
        if (adventure != null) {
            adventure.close();
            adventure = null;
        }
    }

    @NotNull
    public static BukkitAudiences getAdventure() {
        if (adventure == null) {
            throw new IllegalStateException("Tried to access Adventure when the plugin was disabled!");
        }
        return adventure;
    }

    public static Main getInstance() {
        return instance;
    }

    public static TaskScheduler getScheduler() {
        return scheduler;
    }

    public static List<String> getLanguages() {
        return languages;
    }
}

