/*
 * Decompiled with CFR 0.152.
 */
package echotrace.commands.subcommands;

import com.mojang.brigadier.context.CommandContext;
import com.tchristofferson.configupdater.ConfigUpdater;
import echotrace.Main;
import echotrace.config.Config;
import echotrace.config.Lang;
import echotrace.core.TraceManager;
import echotrace.core.TraceRenderer;
import echotrace.util.Logger;
import echotrace.util.MessageUtils;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import java.io.File;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;

public class ReloadCommand {
    public static int execute(CommandContext<CommandSourceStack> ctx) {
        try {
            Main.getInstance().saveDefaultConfig();
            File configFile = new File(Main.getInstance().getDataFolder(), "config.yml");
            ConfigUpdater.update((Plugin)Main.getInstance(), "config.yml", configFile, new String[0]);
            Main.getInstance().reloadConfig();
            Config.load(Main.getInstance().getConfig());
            File languageDir = new File(Main.getInstance().getDataFolder(), "language");
            if (!languageDir.exists()) {
                languageDir.mkdirs();
            }
            for (String langFileName : Main.getLanguages()) {
                if (!new File(languageDir, langFileName).exists()) {
                    Main.getInstance().saveResource("language/" + langFileName, false);
                }
                ConfigUpdater.update((Plugin)Main.getInstance(), "language/" + langFileName, new File(languageDir, langFileName), new String[0]);
            }
            File languageFile = new File(languageDir, Config.language + ".yml");
            if (!languageFile.exists()) {
                Logger.logErr("Language " + Config.language + " doesn't exist in your language folder! Defaulting to English (en).");
                languageFile = new File(languageDir, "en.yml");
                if (!languageFile.exists()) {
                    Main.getInstance().saveResource("language/en.yml", false);
                }
            }
            YamlConfiguration languageConfig = YamlConfiguration.loadConfiguration((File)languageFile);
            Lang.load((FileConfiguration)languageConfig);
            TraceManager.startHeartbeat();
            TraceRenderer.startHeartbeat();
            MessageUtils.notifySender(ctx.getSource().getSender(), Config.prefix + Lang.echotrace_reload_success);
            return 1;
        }
        catch (Exception e) {
            MessageUtils.notifySender(ctx.getSource().getSender(), Config.prefix + Lang.echotrace_reload_failure);
            return 0;
        }
    }
}

