/*
 * Decompiled with CFR 0.152.
 */
package echotrace.commands.subcommands;

import com.github.Anon8281.universalScheduler.scheduling.tasks.MyScheduledTask;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.LongArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.context.ParsedCommandNode;
import com.mojang.brigadier.context.StringRange;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.tree.ArgumentCommandNode;
import com.mojang.brigadier.tree.CommandNode;
import echotrace.Main;
import echotrace.config.Config;
import echotrace.config.Lang;
import echotrace.core.Trace;
import echotrace.core.TraceManager;
import echotrace.core.TraceRenderer;
import echotrace.core.targets.BlockTarget;
import echotrace.core.targets.EntityTarget;
import echotrace.core.targets.PlayerTarget;
import echotrace.core.targets.PositionTarget;
import echotrace.util.MessageUtils;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.argument.resolvers.FinePositionResolver;
import io.papermc.paper.command.brigadier.argument.resolvers.selector.EntitySelectorArgumentResolver;
import io.papermc.paper.math.FinePosition;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.Nullable;

public class TraceCommand {
    private static final Map<UUID, List<MyScheduledTask>> ACTIVE = new ConcurrentHashMap<UUID, List<MyScheduledTask>>();
    private static final Map<UUID, Long> COOLDOWN = new ConcurrentHashMap<UUID, Long>();

    private static void addTask(UUID uuid, MyScheduledTask task) {
        ACTIVE.computeIfAbsent(uuid, k -> Collections.synchronizedList(new ArrayList())).add(task);
    }

    private static void removeTask(UUID uuid, MyScheduledTask task) {
        List<MyScheduledTask> list = ACTIVE.get(uuid);
        if (list != null) {
            list.remove(task);
            if (list.isEmpty()) {
                ACTIVE.remove(uuid);
            }
        }
    }

    private static void cancelAll(UUID uuid) {
        List<MyScheduledTask> list = ACTIVE.remove(uuid);
        TraceRenderer.clearQueuedRenders(uuid);
        if (list == null || list.isEmpty()) {
            return;
        }
        for (MyScheduledTask task : list) {
            task.cancel();
        }
    }

    public static int executeEntity(CommandContext<CommandSourceStack> ctx, boolean hasPointsArg) {
        CommandSourceStack src = ctx.getSource();
        Player player = (Player)src.getExecutor();
        if (player == null) {
            return 1;
        }
        if (TraceCommand.isOnCooldown(player, Config.cooldown_entity)) {
            return 1;
        }
        EntitySelectorArgumentResolver resolver = ctx.getArgument("entity", EntitySelectorArgumentResolver.class);
        try {
            long pointCount = hasPointsArg ? LongArgumentType.getLong(ctx, "points") : Config.default_points;
            List targets = (List)resolver.resolve(src);
            int count = 0;
            boolean ww = false;
            for (Entity target : targets) {
                if (player.getWorld() != target.getWorld()) {
                    ww = true;
                    continue;
                }
                TraceManager.registerTrace(new Trace(player, new EntityTarget(target), pointCount));
                ++count;
            }
            if (count > 0) {
                MessageUtils.notifyPlayer(player, Config.prefix + Lang.echotrace_trace_success.replace("{Count}", String.valueOf(count)));
            } else if (ww) {
                MessageUtils.notifyPlayer(player, Config.prefix + Lang.echotrace_trace_wrong_world);
            } else {
                MessageUtils.notifyPlayer(player, Config.prefix + Lang.echotrace_trace_no_target);
            }
            return 1;
        }
        catch (CommandSyntaxException e) {
            MessageUtils.notifyPlayer(player, Config.prefix + Lang.echotrace_trace_no_target);
            return 1;
        }
    }

    public static int executePlayer(CommandContext<CommandSourceStack> ctx, boolean hasPointsArg) {
        CommandSourceStack src = ctx.getSource();
        Player player = (Player)src.getExecutor();
        if (player == null) {
            return 1;
        }
        if (TraceCommand.isOnCooldown(player, Config.cooldown_player)) {
            return 1;
        }
        String input = StringArgumentType.getString(ctx, "player").trim();
        Player target = Bukkit.getPlayer((String)input);
        if (target == null) {
            MessageUtils.notifyPlayer(player, Config.prefix + Lang.echotrace_trace_no_target);
            return 1;
        }
        if (!player.getWorld().equals((Object)target.getWorld())) {
            MessageUtils.notifyPlayer(player, Config.prefix + Lang.echotrace_trace_wrong_world);
            return 1;
        }
        long pointCount = hasPointsArg ? LongArgumentType.getLong(ctx, "points") : Config.default_points;
        TraceManager.registerTrace(new Trace(player, new PlayerTarget(target), pointCount));
        MessageUtils.notifyPlayer(player, Config.prefix + Lang.echotrace_trace_success.replace("{Count}", "1"));
        return 1;
    }

    public static int executePosition(CommandContext<CommandSourceStack> ctx, boolean hasPointsArg) {
        CommandSourceStack src = ctx.getSource();
        Player player = (Player)src.getExecutor();
        if (player == null) {
            return 1;
        }
        if (TraceCommand.isOnCooldown(player, Config.cooldown_position)) {
            return 1;
        }
        FinePositionResolver resolver = ctx.getArgument("position", FinePositionResolver.class);
        try {
            long pointCount = hasPointsArg ? LongArgumentType.getLong(ctx, "points") : Config.default_points;
            FinePosition target = (FinePosition)resolver.resolve(src);
            TraceManager.registerTrace(new Trace(player, new PositionTarget(target.toLocation(player.getWorld())), pointCount));
            MessageUtils.notifyPlayer(player, Config.prefix + Lang.echotrace_trace_success.replace("{Count}", "1"));
            return 1;
        }
        catch (CommandSyntaxException e) {
            MessageUtils.notifyPlayer(player, Config.prefix + Lang.echotrace_trace_no_target);
            return 1;
        }
    }

    public static int executeBlock(CommandContext<CommandSourceStack> ctx, boolean hasRadius, boolean hasLimit, boolean hasPointsArg) {
        BlockData pattern;
        CommandSourceStack src = ctx.getSource();
        Player player = (Player)src.getExecutor();
        if (player == null) {
            return 1;
        }
        UUID uuid = player.getUniqueId();
        if (TraceCommand.isOnCooldown(player, Config.cooldown_block)) {
            return 1;
        }
        String raw = TraceCommand.rawArg(ctx, "type");
        if (raw == null || raw.isEmpty()) {
            return 1;
        }
        int nbtIdx = raw.indexOf("{");
        if (nbtIdx != -1) {
            raw = raw.substring(0, nbtIdx).trim();
        }
        try {
            Object s = raw.contains(":") ? raw : "minecraft:" + raw;
            pattern = Bukkit.createBlockData((String)s);
        }
        catch (IllegalArgumentException ex) {
            MessageUtils.notifyPlayer(player, Config.prefix + Lang.echotrace_trace_no_target);
            return 1;
        }
        Material wantMat = pattern.getMaterial();
        boolean hasProps = pattern.getAsString(false).contains("[");
        double radius = Math.max(0.0, hasRadius ? DoubleArgumentType.getDouble(ctx, "radius") : (double)Config.default_radius);
        long limit = Math.max(1L, hasLimit ? LongArgumentType.getLong(ctx, "limit") : Long.MAX_VALUE);
        long points = hasPointsArg ? LongArgumentType.getLong(ctx, "points") : Config.default_points;
        World world = player.getWorld();
        Location loc = player.getLocation();
        double cx = loc.getX();
        double cy = loc.getY();
        double cz = loc.getZ();
        double r2 = radius * radius;
        int R = (int)Math.ceil(radius);
        int bx = (int)Math.floor(cx);
        int by = (int)Math.floor(cy);
        int bz = (int)Math.floor(cz);
        int minY = Math.max(world.getMinHeight(), (int)Math.floor(cy - radius));
        int maxY = Math.min(world.getMaxHeight() - 1, (int)Math.floor(cy + radius));
        Main.getScheduler().runTaskAsynchronously(() -> {
            double baseX = (double)bx + 0.5 - cx;
            double baseY = (double)by + 0.5 - cy;
            double baseZ = (double)bz + 0.5 - cz;
            record Offset(int dx, int dy, int dz, double d2) {
            }
            ArrayList<Offset> offsets = new ArrayList<Offset>((2 * R + 1) * (2 * R + 1) * (2 * R + 1));
            for (int dy = -R; dy <= R; ++dy) {
                int y = by + dy;
                if (y < minY || y > maxY) continue;
                for (int dx = -R; dx <= R; ++dx) {
                    double adx = baseX + (double)dx;
                    for (int dz = -R; dz <= R; ++dz) {
                        double ady = baseY + (double)dy;
                        double adz = baseZ + (double)dz;
                        double d2 = adx * adx + ady * ady + adz * adz;
                        if (d2 > r2) continue;
                        offsets.add(new Offset(dx, dy, dz, d2));
                    }
                }
            }
            offsets.sort(Comparator.comparingDouble(Offset::d2));
            MessageUtils.notifyPlayer(player, Config.prefix + Lang.echotrace_trace_check.replace("{Count}", String.valueOf(offsets.size())));
            Main.getScheduler().execute(() -> {
                Iterator it = offsets.iterator();
                int[] found = new int[]{0};
                AtomicReference<MyScheduledTask> taskReference = new AtomicReference<MyScheduledTask>();
                MyScheduledTask task = Main.getScheduler().runTaskTimer(() -> {
                    if (!player.isOnline()) {
                        MyScheduledTask self = (MyScheduledTask)taskReference.get();
                        if (self != null) {
                            self.cancel();
                        }
                        TraceCommand.removeTask(uuid, self);
                        return;
                    }
                    int processed = 0;
                    while ((long)processed++ < Math.max(1L, Config.batch_size) && it.hasNext()) {
                        Chunk chunk;
                        Block block;
                        Offset o = (Offset)it.next();
                        int x = bx + o.dx();
                        int y = by + o.dy();
                        int z = bz + o.dz();
                        if (!world.isChunkLoaded(x >> 4, z >> 4) || (block = (chunk = world.getChunkAt(x >> 4, z >> 4)).getBlock(x & 0xF, y, z & 0xF)).getType() != wantMat || hasProps && !block.getBlockData().matches(pattern)) continue;
                        TraceManager.registerTrace(new Trace(player, new BlockTarget(block), points));
                        found[0] = found[0] + 1;
                        if ((long)found[0] < limit) continue;
                        MessageUtils.notifyPlayer(player, Config.prefix + Lang.echotrace_trace_success.replace("{Count}", String.valueOf(found[0])));
                        MyScheduledTask self = (MyScheduledTask)taskReference.get();
                        if (self != null) {
                            self.cancel();
                        }
                        TraceCommand.removeTask(uuid, self);
                        return;
                    }
                    if (!it.hasNext()) {
                        MessageUtils.notifyPlayer(player, Config.prefix + Lang.echotrace_trace_success.replace("{Count}", String.valueOf(found[0])));
                        MyScheduledTask self = (MyScheduledTask)taskReference.get();
                        if (self != null) {
                            self.cancel();
                        }
                        TraceCommand.removeTask(uuid, self);
                    }
                }, 1L, 1L);
                taskReference.set(task);
                TraceCommand.addTask(uuid, task);
            });
        });
        MessageUtils.notifyPlayer(player, Config.prefix + Lang.echotrace_trace_scan);
        return 1;
    }

    @Nullable
    private static String rawArg(CommandContext<CommandSourceStack> ctx, String name) {
        for (ParsedCommandNode<CommandSourceStack> nodes : ctx.getNodes()) {
            ArgumentCommandNode arg;
            CommandNode<CommandSourceStack> commandNode = nodes.getNode();
            if (!(commandNode instanceof ArgumentCommandNode) || !(arg = (ArgumentCommandNode)commandNode).getName().equals(name)) continue;
            StringRange range = nodes.getRange();
            return range.get(ctx.getInput());
        }
        return null;
    }

    public static int cancel(CommandContext<CommandSourceStack> ctx) {
        CommandSourceStack src = ctx.getSource();
        Player player = (Player)src.getExecutor();
        if (player == null) {
            return 1;
        }
        TraceCommand.cancelAll(player.getUniqueId());
        TraceManager.unregisterTracesFrom(player);
        MessageUtils.notifyPlayer(player, Config.prefix + Lang.echotrace_trace_cancel);
        return 1;
    }

    private static boolean isOnCooldown(Player player, long cooldownMillis) {
        if (player.hasPermission("echotrace.bypass.cooldowns")) {
            return false;
        }
        long now = System.currentTimeMillis();
        UUID uuid = player.getUniqueId();
        Long until = COOLDOWN.get(uuid);
        if (until != null) {
            long remainingMs = until - now;
            if (remainingMs > 0L) {
                MessageUtils.notifyPlayer(player, Config.prefix + Lang.echotrace_trace_cooldown.replace("{Duration}", String.format("%.2f", (double)remainingMs / 1000.0)));
                return true;
            }
            COOLDOWN.remove(uuid, until);
        }
        COOLDOWN.put(uuid, now + cooldownMillis);
        return false;
    }
}

