/*
 * Decompiled with CFR 0.152.
 */
package echotrace.util;

import echotrace.Main;
import echotrace.adventure.audience.Audience;
import echotrace.adventure.text.Component;
import echotrace.adventure.text.TextComponent;
import echotrace.adventure.title.Title;
import echotrace.colorparser.ColorParser;
import echotrace.config.Config;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class MessageUtils {
    public static void notifyPlayer(Player player, String message) {
        if (message.substring(Config.prefix.length()).trim().isEmpty()) {
            return;
        }
        Audience audience = Main.getAdventure().player(player);
        if (message.trim().toUpperCase().startsWith("ACTIONBAR:")) {
            String actionbarText = message.trim().substring(10).trim();
            Component actionbarMessage = ColorParser.of(actionbarText).parsePAPIPlaceholders(player).parseLegacy().build();
            audience.sendActionBar(actionbarMessage);
        } else if (message.trim().toUpperCase().startsWith("TITLE:")) {
            String[] parts = message.trim().substring(6).split(";", 2);
            TextComponent title = parts.length > 0 ? ColorParser.of(parts[0].trim()).parsePAPIPlaceholders(player).parseLegacy().build() : Component.empty();
            TextComponent subtitle = parts.length > 1 ? ColorParser.of(parts[1].trim()).parsePAPIPlaceholders(player).parseLegacy().build() : Component.empty();
            audience.showTitle(Title.title(title, subtitle));
        } else {
            Component chatMessage = ColorParser.of(message).parsePAPIPlaceholders(player).parseLegacy().build();
            audience.sendMessage(chatMessage);
        }
    }

    public static void notifyConsole(String message) {
        if (message.substring(Config.prefix.length()).trim().isEmpty()) {
            return;
        }
        Audience audience = Main.getAdventure().console();
        Component chatMessage = ColorParser.of(message).parseLegacy().build();
        audience.sendMessage(chatMessage);
    }

    public static void notifySender(CommandSender sender, String message) {
        if (sender instanceof Player) {
            MessageUtils.notifyPlayer((Player)sender, message);
        } else {
            MessageUtils.notifyConsole(message);
        }
    }
}

