/*
 * Decompiled with CFR 0.152.
 */
package DA.daclearlag;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Daclearlag
implements ModInitializer {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"DAClearLag");
    private static final int CLEAR_LAG_INTERVAL = 300;
    private static final int WARNING_TIME = 30;
    private final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
    private MinecraftServer server;

    public void onInitialize() {
        LOGGER.info("Initializing DAClearLag mod...");
        ServerLifecycleEvents.SERVER_STARTED.register(server -> {
            this.server = server;
            LOGGER.info("Server started, scheduling clear lag task.");
            this.startClearLagCycle();
        });
        ServerLifecycleEvents.SERVER_STOPPING.register(server -> {
            LOGGER.info("Server stopping, shutting down scheduler...");
            this.scheduler.shutdown();
            try {
                if (!this.scheduler.awaitTermination(5L, TimeUnit.SECONDS)) {
                    this.scheduler.shutdownNow();
                }
            }
            catch (InterruptedException e) {
                LOGGER.error("Error while shutting down scheduler", (Throwable)e);
                this.scheduler.shutdownNow();
            }
        });
    }

    private void startClearLagCycle() {
        this.scheduler.scheduleAtFixedRate(() -> {
            if (this.server == null) {
                LOGGER.warn("Server instance is null, skipping clear lag cycle.");
                return;
            }
            this.scheduler.schedule(() -> {
                this.broadcastMessage("\u00a74[DAClearLag]: All ground items will be cleared in 30 seconds!");
                LOGGER.info("Broadcasted 30-second warning.");
                this.scheduler.schedule(() -> {
                    int clearedItems = this.clearGroundItems();
                    this.broadcastMessage("\u00a76[DAClearLag]: Cleared " + clearedItems + " ground items.");
                    LOGGER.info("Clearing task completed.");
                }, 30L, TimeUnit.SECONDS);
            }, 270L, TimeUnit.SECONDS);
        }, 0L, 300L, TimeUnit.SECONDS);
    }

    private void broadcastMessage(String message) {
        if (this.server != null) {
            for (class_3222 player : this.server.method_3760().method_14571()) {
                player.method_7353((class_2561)class_2561.method_43470((String)message), false);
            }
        } else {
            LOGGER.warn("Cannot broadcast message: server is null.");
        }
    }

    private int clearGroundItems() {
        int clearedItems = 0;
        if (this.server != null) {
            for (class_3218 world : this.server.method_3738()) {
                if (world != null) {
                    LOGGER.info("Scanning world: {}", (Object)world.method_27983().method_29177());
                    for (class_1297 entity : world.method_27909()) {
                        if (!(entity instanceof class_1542)) continue;
                        class_1542 item = (class_1542)entity;
                        LOGGER.debug("Found ItemEntity at {}: {}", (Object)item.method_24515(), (Object)item.method_6983().method_7909().method_7848());
                        item.method_31472();
                        ++clearedItems;
                    }
                    continue;
                }
                LOGGER.warn("Encountered null world during item clearing.");
            }
            LOGGER.info("Cleared {} items from all worlds.", (Object)clearedItems);
        } else {
            LOGGER.warn("Cannot clear items: server is null.");
        }
        return clearedItems;
    }
}

