/*
 * Decompiled with CFR 0.152.
 */
package com.xiaopiao.patternbetter.mixin;

import appeng.client.Point;
import appeng.client.gui.ICompositeWidget;
import appeng.client.gui.widgets.VerticalButtonBar;
import appeng.core.AppEng;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.resources.ResourceLocation;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={VerticalButtonBar.class})
public abstract class VerticalButtonBarMixin
implements ICompositeWidget {
    @Shadow
    private Point position;
    @Shadow
    @Final
    private static int MARGIN;
    @Shadow
    @Final
    private List<Button> buttons;
    @Shadow
    private Point screenOrigin;
    @Shadow
    @Final
    private static int VERTICAL_SPACING;
    @Shadow
    private Rect2i bounds;
    ResourceLocation rs = ResourceLocation.fromNamespaceAndPath((String)"patternbetter", (String)"rightbar");
    @Unique
    boolean isRight = false;

    @Shadow
    public abstract Rect2i getBounds();

    @Unique
    public void setRight(boolean right) {
        this.isRight = right;
    }

    @Overwrite
    public void drawBackgroundLayer(GuiGraphics guiGraphics, Rect2i bounds, Point mouse) {
        if (this.isRight) {
            guiGraphics.blitSprite(this.rs, bounds.getX() + this.getBounds().getX() + this.getBounds().getWidth(), bounds.getY() + this.getBounds().getY() - 1, 1, this.getBounds().getWidth() + 1, this.getBounds().getHeight() + 4);
        } else {
            guiGraphics.blitSprite(AppEng.makeId((String)"vertical_buttons_bg"), bounds.getX() + this.getBounds().getX() - 2, bounds.getY() + this.getBounds().getY() - 1, 1, this.getBounds().getWidth() + 1, this.getBounds().getHeight() + 4);
        }
    }

    @Overwrite
    public void updateBeforeRender() {
        int currentY = this.position.getY() + MARGIN;
        int maxWidth = 0;
        for (Button button : this.buttons) {
            if (!button.visible) continue;
            if (this.isRight) {
                button.setX(this.screenOrigin.getX() + this.position.getX() - MARGIN - button.getWidth() + this.getBounds().getWidth());
            } else {
                button.setX(this.screenOrigin.getX() + this.position.getX() - MARGIN - button.getWidth());
            }
            button.setY(this.screenOrigin.getY() + currentY);
            currentY += button.getHeight() + VERTICAL_SPACING;
            maxWidth = Math.max(button.getWidth(), maxWidth);
        }
        if (maxWidth == 0) {
            this.bounds = new Rect2i(0, 0, 0, 0);
        } else {
            int boundX = this.position.getX() - maxWidth - 2 * MARGIN;
            int boundY = this.position.getY();
            this.bounds = new Rect2i(boundX, boundY, maxWidth + 2 * MARGIN, currentY - boundY);
        }
    }
}

