/*
 * Decompiled with CFR 0.152.
 */
package com.xiaopiao.patternbetter.mixin;

import appeng.api.crafting.IPatternDetails;
import appeng.api.crafting.PatternDetailsHelper;
import appeng.api.stacks.GenericStack;
import appeng.crafting.pattern.AEProcessingPattern;
import appeng.helpers.patternprovider.PatternProviderLogicHost;
import appeng.menu.AEBaseMenu;
import appeng.menu.SlotSemantics;
import appeng.menu.implementations.PatternProviderMenu;
import com.glodblock.github.extendedae.container.ContainerExPatternProvider;
import com.glodblock.github.glodium.network.packet.sync.IActionHolder;
import com.glodblock.github.glodium.network.packet.sync.Paras;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Implements;
import org.spongepowered.asm.mixin.Interface;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={PatternProviderMenu.class})
@Implements(value={@Interface(iface=IActionHolder.class, prefix="IActionHolder$")})
public abstract class PatternProviderMenuMixin
extends AEBaseMenu {
    @Unique
    private final Map<String, Consumer<Paras>> actionMap = ((IActionHolder)this).createHolder();
    @Unique
    ContainerExPatternProvider provider;
    @Unique
    private int playerSlotCount;

    public PatternProviderMenuMixin(MenuType<?> menuType, int id, Inventory playerInventory, Object host) {
        super(menuType, id, playerInventory, host);
    }

    @Inject(method={"<init>(Lnet/minecraft/world/inventory/MenuType;ILnet/minecraft/world/entity/player/Inventory;Lappeng/helpers/patternprovider/PatternProviderLogicHost;)V"}, at={@At(value="RETURN")}, remap=false)
    public void init(MenuType menuType, int id, Inventory playerInventory, PatternProviderLogicHost host, CallbackInfo ci) {
        List playerSlots = this.getSlots(SlotSemantics.PLAYER_INVENTORY);
        this.playerSlotCount = playerSlots.size();
        this.actionMap.put("multiply2", paras -> this.multiply2(false, 2));
        this.actionMap.put("divide2", paras -> this.multiply2(true, 2));
        this.actionMap.put("multiply5", paras -> this.multiply2(false, 5));
        this.actionMap.put("divide5", paras -> this.multiply2(true, 5));
        this.actionMap.put("multiply10", paras -> this.multiply2(false, 10));
        this.actionMap.put("divide10", paras -> this.multiply2(true, 10));
        this.actionMap.put("patternsInto", paras -> this.patternsInto());
        this.actionMap.put("balance", paras -> this.balanceMultiply());
        PatternProviderMenu patternProviderMenu = (PatternProviderMenu)this;
        if (patternProviderMenu instanceof ContainerExPatternProvider) {
            ContainerExPatternProvider p;
            this.provider = p = (ContainerExPatternProvider)patternProviderMenu;
        }
    }

    @Unique
    public void balanceMultiply() {
        List slots = this.getSlots(SlotSemantics.ENCODED_PATTERN);
        ArrayList<Long> GBCs = new ArrayList<Long>();
        for (Slot slot : slots) {
            ItemStack stack = slot.m_7993_();
            IPatternDetails detail = PatternDetailsHelper.decodePattern((ItemStack)stack, (Level)this.getPlayer().m_9236_());
            if (!(detail instanceof AEProcessingPattern)) continue;
            AEProcessingPattern process = (AEProcessingPattern)detail;
            GenericStack[] input = process.getSparseInputs();
            GenericStack[] output = process.getOutputs();
            ArrayList<GenericStack> inputs = new ArrayList<GenericStack>();
            inputs.addAll(Arrays.asList(input));
            inputs.addAll(Arrays.asList(output));
            long[] inputAmount = inputs.stream().filter(Objects::nonNull).filter(stack1 -> stack1.amount() > 0L).mapToLong(GenericStack::amount).toArray();
            long l = this.gcdOfArray(inputAmount);
            GenericStack[] mulInput = (GenericStack[])Arrays.stream(input).filter(Objects::nonNull).map(stack1 -> new GenericStack(stack1.what(), stack1.amount() / l)).toArray(GenericStack[]::new);
            GenericStack[] mulOutput = (GenericStack[])Arrays.stream(output).filter(Objects::nonNull).map(stack1 -> new GenericStack(stack1.what(), stack1.amount() / l)).toArray(GenericStack[]::new);
            ItemStack newPattern = PatternDetailsHelper.encodeProcessingPattern((GenericStack[])mulInput, (GenericStack[])mulOutput);
            slot.m_5852_(newPattern);
            GBCs.add(l);
        }
        long maxGCD = GBCs.stream().max(Long::compareTo).orElse(1L);
        this.multiply2(false, (int)maxGCD);
    }

    @Unique
    public long gcd(long a, long b) {
        while (b != 0L) {
            long temp = b;
            b = a % b;
            a = temp;
        }
        return a;
    }

    @Unique
    public long gcdOfArray(long[] numbers) {
        if (numbers.length == 0) {
            return 1L;
        }
        long currentGcd = numbers[0];
        for (long i = 1L; i < (long)numbers.length && (currentGcd = this.gcd(currentGcd, numbers[Math.toIntExact(i)])) != 1L; ++i) {
        }
        return currentGcd;
    }

    @Unique
    public boolean getEdit(int slotIndex) {
        try {
            if (this.provider == null) {
                throw new RuntimeException("ContainerExPatternProvider is null");
            }
            Class<?> aClass = this.provider.getClass();
            Field field = aClass.getDeclaredField("allSlotStates");
            BitSet o = (BitSet)field.get(this.provider);
            return o.get(slotIndex - 36);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }

    @Unique
    public void patternsInto() {
        List playerSlots = this.getSlots(SlotSemantics.PLAYER_INVENTORY);
        List patternSlots = this.getSlots(SlotSemantics.ENCODED_PATTERN);
        ArrayList<ItemStack> patternsToMove = new ArrayList<ItemStack>();
        for (Slot slot : playerSlots) {
            ItemStack item = slot.m_7993_();
            if (!PatternDetailsHelper.isEncodedPattern((ItemStack)item)) continue;
            patternsToMove.add(item.m_41777_());
            slot.m_5852_(ItemStack.f_41583_);
        }
        int patternIndex = 0;
        for (Slot patternSlot : patternSlots) {
            if (!patternSlot.m_7993_().m_41619_() || patternIndex >= patternsToMove.size()) continue;
            patternSlot.m_5852_((ItemStack)patternsToMove.get(patternIndex));
            ++patternIndex;
        }
    }

    @Unique
    public void multiply2(boolean is, int i) {
        List slots = this.getSlots(SlotSemantics.ENCODED_PATTERN);
        for (Slot slot : slots) {
            ItemStack newPattern;
            GenericStack[] mulOutput;
            GenericStack[] mulInput;
            GenericStack[] output;
            GenericStack[] input;
            AEProcessingPattern process;
            IPatternDetails detail;
            ItemStack stack;
            if (this.provider == null) {
                stack = slot.m_7993_();
                detail = PatternDetailsHelper.decodePattern((ItemStack)stack, (Level)this.getPlayer().m_9236_());
                if (!(detail instanceof AEProcessingPattern)) continue;
                process = (AEProcessingPattern)detail;
                input = process.getSparseInputs();
                output = process.getOutputs();
                mulInput = new GenericStack[input.length];
                mulOutput = new GenericStack[output.length];
                if ((PatternProviderMenuMixin.hasStackWithCountOne(input, i) || PatternProviderMenuMixin.hasStackWithCountOne(output, i)) && is) continue;
                this.modifyStacks(input, mulInput, i, is);
                this.modifyStacks(output, mulOutput, i, is);
                newPattern = PatternDetailsHelper.encodeProcessingPattern((GenericStack[])mulInput, (GenericStack[])mulOutput);
                slot.m_5852_(newPattern);
                continue;
            }
            if (!this.getEdit(slot.f_40219_) || !((detail = PatternDetailsHelper.decodePattern((ItemStack)(stack = slot.m_7993_()), (Level)this.getPlayer().m_9236_())) instanceof AEProcessingPattern)) continue;
            process = (AEProcessingPattern)detail;
            input = process.getSparseInputs();
            output = process.getOutputs();
            mulInput = new GenericStack[input.length];
            mulOutput = new GenericStack[output.length];
            if ((PatternProviderMenuMixin.hasStackWithCountOne(input, i) || PatternProviderMenuMixin.hasStackWithCountOne(output, i)) && is) continue;
            this.modifyStacks(input, mulInput, i, is);
            this.modifyStacks(output, mulOutput, i, is);
            newPattern = PatternDetailsHelper.encodeProcessingPattern((GenericStack[])mulInput, (GenericStack[])mulOutput);
            slot.m_5852_(newPattern);
        }
    }

    @Unique
    private void modifyStacks(GenericStack[] input, GenericStack[] mulInput, int scale, boolean div) {
        for (int i = 0; i < input.length; ++i) {
            if (input[i] == null) continue;
            long amt = div ? input[i].amount() / (long)scale : input[i].amount() * (long)scale;
            mulInput[i] = new GenericStack(input[i].what(), amt);
        }
    }

    @Unique
    private static boolean hasStackWithCountOne(GenericStack[] stacks, int i) {
        for (GenericStack stack : stacks) {
            if (stack == null || stack.amount() % (long)i == 0L && stack.amount() / (long)i >= 0L) continue;
            return true;
        }
        return false;
    }

    @Unique
    @NotNull
    public Map<String, Consumer<Paras>> IActionHolder$getActionMap() {
        return this.actionMap;
    }
}

