/*
 * Decompiled with CFR 0.152.
 */
package com.xiaopiao.patternbetter.mixin;

import appeng.api.crafting.IPatternDetails;
import appeng.api.crafting.PatternDetailsHelper;
import appeng.api.stacks.GenericStack;
import appeng.crafting.pattern.AEProcessingPattern;
import appeng.helpers.patternprovider.PatternProviderLogicHost;
import appeng.menu.AEBaseMenu;
import appeng.menu.SlotSemantics;
import appeng.menu.implementations.PatternProviderMenu;
import com.glodblock.github.glodium.network.packet.sync.IActionHolder;
import com.glodblock.github.glodium.network.packet.sync.Paras;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Implements;
import org.spongepowered.asm.mixin.Interface;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={PatternProviderMenu.class})
@Implements(value={@Interface(iface=IActionHolder.class, prefix="IActionHolder$")})
public abstract class PatternProviderMenuMixin
extends AEBaseMenu {
    @Unique
    private final Map<String, Consumer<Paras>> actionMap = ((IActionHolder)this).createHolder();

    public PatternProviderMenuMixin(MenuType<?> menuType, int id, Inventory playerInventory, Object host) {
        super(menuType, id, playerInventory, host);
    }

    @Inject(method={"<init>(Lnet/minecraft/world/inventory/MenuType;ILnet/minecraft/world/entity/player/Inventory;Lappeng/helpers/patternprovider/PatternProviderLogicHost;)V"}, at={@At(value="RETURN")}, remap=false)
    public void init(MenuType menuType, int id, Inventory playerInventory, PatternProviderLogicHost host, CallbackInfo ci) {
        this.actionMap.put("multiply2", paras -> this.multiply2(false, 2));
        this.actionMap.put("divide2", paras -> this.multiply2(true, 2));
        this.actionMap.put("multiply5", paras -> this.multiply2(false, 5));
        this.actionMap.put("divide5", paras -> this.multiply2(true, 5));
        this.actionMap.put("multiply10", paras -> this.multiply2(false, 10));
        this.actionMap.put("divide10", paras -> this.multiply2(true, 10));
    }

    @Unique
    public void multiply2(boolean is, int i) {
        List slots = this.getSlots(SlotSemantics.ENCODED_PATTERN);
        for (Slot slot : slots) {
            ItemStack stack = slot.m_7993_();
            IPatternDetails detail = PatternDetailsHelper.decodePattern((ItemStack)stack, (Level)this.getPlayer().m_9236_());
            if (!(detail instanceof AEProcessingPattern)) continue;
            AEProcessingPattern process = (AEProcessingPattern)detail;
            GenericStack[] input = process.getSparseInputs();
            GenericStack[] output = process.getOutputs();
            GenericStack[] mulInput = new GenericStack[input.length];
            GenericStack[] mulOutput = new GenericStack[output.length];
            if ((PatternProviderMenuMixin.hasStackWithCountOne(input, i) || PatternProviderMenuMixin.hasStackWithCountOne(output, i)) && is) continue;
            this.modifyStacks(input, mulInput, i, is);
            this.modifyStacks(output, mulOutput, i, is);
            ItemStack newPattern = PatternDetailsHelper.encodeProcessingPattern((GenericStack[])mulInput, (GenericStack[])mulOutput);
            slot.m_5852_(newPattern);
        }
    }

    private void modifyStacks(GenericStack[] input, GenericStack[] mulInput, int scale, boolean div) {
        for (int i = 0; i < input.length; ++i) {
            if (input[i] == null) continue;
            long amt = div ? input[i].amount() / (long)scale : input[i].amount() * (long)scale;
            mulInput[i] = new GenericStack(input[i].what(), amt);
        }
    }

    private static boolean hasStackWithCountOne(GenericStack[] stacks, int i) {
        for (GenericStack stack : stacks) {
            if (stack == null || stack.amount() % (long)i == 0L && stack.amount() / (long)i >= 0L) continue;
            return true;
        }
        return false;
    }

    @Unique
    @NotNull
    public Map<String, Consumer<Paras>> IActionHolder$getActionMap() {
        return this.actionMap;
    }
}

