/*
 * Decompiled with CFR 0.152.
 */
package com.xiaopiao.patternbetter.mixin;

import appeng.client.Point;
import appeng.client.gui.ICompositeWidget;
import appeng.client.gui.widgets.VerticalButtonBar;
import java.util.List;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.renderer.Rect2i;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={VerticalButtonBar.class})
public abstract class VerticalButtonBarMixin
implements ICompositeWidget {
    @Shadow(remap=false)
    private Point position;
    @Shadow(remap=false)
    @Final
    private static int MARGIN;
    @Shadow(remap=false)
    @Final
    private List<Button> buttons;
    @Shadow(remap=false)
    private Point screenOrigin;
    @Shadow(remap=false)
    @Final
    private static int VERTICAL_SPACING;
    @Shadow(remap=false)
    private Rect2i bounds;
    @Unique
    boolean isRight = false;

    @Shadow(remap=false)
    public abstract Rect2i getBounds();

    @Unique
    public void setRight(boolean right) {
        this.isRight = right;
    }

    @Overwrite(remap=false)
    public void updateBeforeRender() {
        int currentY = this.position.getY() + MARGIN;
        int maxWidth = 0;
        for (Button button : this.buttons) {
            if (!button.f_93624_) continue;
            if (this.isRight) {
                button.m_252865_(this.screenOrigin.getX() + this.position.getX() - MARGIN - button.m_5711_() + this.getBounds().m_110090_());
            } else {
                button.m_252865_(this.screenOrigin.getX() + this.position.getX() - MARGIN - button.m_5711_());
            }
            button.m_253211_(this.screenOrigin.getY() + currentY);
            currentY += button.m_93694_() + VERTICAL_SPACING;
            maxWidth = Math.max(button.m_5711_(), maxWidth);
        }
        if (maxWidth == 0) {
            this.bounds = new Rect2i(0, 0, 0, 0);
        } else {
            int boundX = this.position.getX() - maxWidth - 2 * MARGIN;
            int boundY = this.position.getY();
            this.bounds = new Rect2i(boundX, boundY, maxWidth + 2 * MARGIN, currentY - boundY);
        }
    }
}

