/*
 * Decompiled with CFR 0.152.
 */
package org.lushplugins.pvptoggle.libraries.placeholderhandler.placeholder.node;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.lushplugins.pvptoggle.libraries.placeholderhandler.parameter.PlaceholderParameter;
import org.lushplugins.pvptoggle.libraries.placeholderhandler.placeholder.PlaceholderContext;
import org.lushplugins.pvptoggle.libraries.placeholderhandler.placeholder.node.LiteralNode;
import org.lushplugins.pvptoggle.libraries.placeholderhandler.placeholder.node.ParameterNode;

public abstract class PlaceholderNode
implements Comparable<PlaceholderNode> {
    private final int priority;

    public PlaceholderNode(int priority) {
        this.priority = priority;
    }

    public int priority() {
        return this.priority;
    }

    public abstract boolean test(String var1, PlaceholderContext var2);

    @Override
    public int compareTo(@NotNull PlaceholderNode other) {
        return Integer.compare(this.priority, other.priority());
    }

    public static List<PlaceholderNode> create(String path, Map<String, PlaceholderParameter<?>> parameters) {
        if (path.startsWith("%") && path.endsWith("%")) {
            path = path.substring(1, path.length() - 1);
        }
        return Arrays.stream(path.split("_")).map(parameter -> {
            if (parameter.startsWith("<") && parameter.endsWith(">")) {
                String parameterName = parameter.substring(1, parameter.length() - 1);
                PlaceholderParameter storedParameter = (PlaceholderParameter)parameters.get(parameterName);
                if (storedParameter != null) {
                    return new ParameterNode(storedParameter.type(), storedParameter.provider());
                }
                throw new IllegalArgumentException("Could not find a parameter with name '%s'".formatted(parameterName));
            }
            return new LiteralNode((String)parameter);
        }).toList();
    }

    public static List<PlaceholderNode> create(String path) {
        return PlaceholderNode.create(path, Collections.emptyMap());
    }
}

