/*
 * Decompiled with CFR 0.152.
 */
package org.lushplugins.pvptoggle.libraries.pluginupdater.api.listener;

import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.lushplugins.chatcolorhandler.ChatColorHandler;
import org.lushplugins.pvptoggle.libraries.pluginupdater.api.updater.PluginData;
import org.lushplugins.pvptoggle.libraries.pluginupdater.api.updater.Updater;

public class NotificationHandler
implements Listener {
    private final Updater updater;
    private final String notificationPermission;
    private final String notificationMessage;

    public NotificationHandler(Updater updater, String notificationPermission, String notificationMessage) {
        this.updater = updater;
        this.notificationPermission = notificationPermission;
        this.notificationMessage = notificationMessage;
        updater.getPlugin().getServer().getPluginManager().registerEvents((Listener)this, updater.getPlugin());
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        PluginData pluginData;
        Player player = event.getPlayer();
        if ((this.notificationPermission == null || player.hasPermission(this.notificationPermission)) && (pluginData = this.updater.getPluginData()).isUpdateAvailable() && !pluginData.isAlreadyDownloaded()) {
            Bukkit.getScheduler().runTaskLaterAsynchronously(this.updater.getPlugin(), () -> ChatColorHandler.sendMessage((CommandSender)player, this.notificationMessage.replace("%plugin%", pluginData.getPluginName()).replace("%current_version%", pluginData.getCurrentVersion()).replace("%latest_version%", pluginData.getLatestVersion())), 40L);
        }
    }
}

