/*
 * Decompiled with CFR 0.152.
 */
package org.lushplugins.pvptoggle.hooks;

import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldguard.WorldGuard;
import com.sk89q.worldguard.protection.ApplicableRegionSet;
import com.sk89q.worldguard.protection.flags.Flag;
import com.sk89q.worldguard.protection.flags.StateFlag;
import com.sk89q.worldguard.protection.flags.registry.FlagConflictException;
import com.sk89q.worldguard.protection.flags.registry.FlagRegistry;
import com.sk89q.worldguard.protection.managers.RegionManager;
import com.sk89q.worldguard.protection.regions.ProtectedRegion;
import com.sk89q.worldguard.protection.regions.RegionContainer;
import java.util.Comparator;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.lushplugins.pvptoggle.PvPToggle;
import org.lushplugins.pvptoggle.libraries.lushlib.hook.Hook;

public class WorldGuardHook
extends Hook {
    private static StateFlag PVP_TOGGLE_FLAG;

    public WorldGuardHook() {
        super("WorldGuard");
    }

    @Override
    public void onEnable() {
        if (PVP_TOGGLE_FLAG == null) {
            PVP_TOGGLE_FLAG = this.registerStateFlag("pvp-toggle", true);
        }
    }

    public void checkPvPRegion(@NotNull Player player) {
        World world = player.getWorld();
        if (PvPToggle.getInstance().getConfigManager().isWorldIgnored(world.getName())) {
            return;
        }
        PvPToggle.getInstance().getConfigManager().sendMessage((CommandSender)player, this.isRegionEnabled(player) ? "pvp-region-enabled" : "pvp-region-disabled");
    }

    public boolean isRegionEnabled(@NotNull Player player) {
        return this.isRegionEnabled(player.getWorld(), player.getLocation());
    }

    public boolean isRegionEnabled(@NotNull World world, @NotNull Location location) {
        return this.getRegionFlagState(world, location, PVP_TOGGLE_FLAG);
    }

    private boolean getRegionFlagState(@NotNull World world, @NotNull Location location, @NotNull StateFlag flag) {
        RegionContainer container = WorldGuard.getInstance().getPlatform().getRegionContainer();
        RegionManager regionManager = container.get(BukkitAdapter.adapt((World)world));
        if (regionManager == null) {
            return true;
        }
        ApplicableRegionSet set = regionManager.getApplicableRegions(BukkitAdapter.adapt((Location)location).toVector().toBlockPoint());
        List<ProtectedRegion> regions = set.getRegions().stream().sorted(Comparator.comparing(ProtectedRegion::getPriority)).toList();
        if (regions.isEmpty()) {
            return true;
        }
        ProtectedRegion region = regions.get(0);
        StateFlag.State state = (StateFlag.State)region.getFlag((Flag)flag);
        return state == null || state.equals((Object)StateFlag.State.ALLOW);
    }

    private StateFlag registerStateFlag(@NotNull String name, boolean def) {
        FlagRegistry registry = WorldGuard.getInstance().getFlagRegistry();
        try {
            StateFlag flag = new StateFlag(name, def);
            registry.register((Flag)flag);
            return flag;
        }
        catch (FlagConflictException e) {
            StateFlag flag;
            Flag existing = registry.get(name);
            return existing instanceof StateFlag ? (flag = (StateFlag)existing) : null;
        }
    }
}

