/*
 * Decompiled with CFR 0.152.
 */
package org.lushplugins.pvptoggle.libraries.enchantedstorage.EnchantedStorage;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.lushplugins.pvptoggle.libraries.enchantedstorage.EnchantedStorage.Storage;

public class IOHandler<T, E> {
    private final ProcessingData<T, E> POISON = new ProcessingData();
    private final Storage<T, E> storage;
    private final ExecutorService threads = Executors.newFixedThreadPool(1);
    private final LinkedBlockingQueue<ProcessingData<T, E>> queue = new LinkedBlockingQueue();

    public IOHandler(Storage<T, E> storage) {
        this.storage = storage;
    }

    public void enable() {
        this.threads.submit(() -> Thread.currentThread().setName("EnchantedStorage IO Thread"));
        this.threads.submit(this::processQueue);
    }

    public void disable() {
        try {
            this.queue.put(this.POISON);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public boolean shutdown() {
        try {
            this.queue.put(this.POISON);
            this.threads.shutdown();
            return this.threads.awaitTermination(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            return false;
        }
    }

    private void processQueue() {
        block6: while (true) {
            try {
                while (true) {
                    ProcessingData<T, E> processingData;
                    if ((processingData = this.queue.take()) == this.POISON) {
                        return;
                    }
                    if (processingData instanceof SavingData) {
                        SavingData savingData = (SavingData)processingData;
                        try {
                            Object t = savingData.getObject();
                            this.storage.save(t);
                            savingData.getFuture().complete(t);
                            continue block6;
                        }
                        catch (Throwable e) {
                            savingData.getFuture().completeExceptionally(e);
                            continue;
                        }
                    }
                    LoadingData loadingData = (LoadingData)processingData;
                    try {
                        T t = this.storage.load(((LoadingData)processingData).getId());
                        loadingData.getFuture().complete(t);
                        continue block6;
                    }
                    catch (Throwable e) {
                        loadingData.getFuture().completeExceptionally(e);
                        continue;
                    }
                    break;
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }

    public CompletableFuture<T> saveData(T t) {
        SavingData savingData = new SavingData(t);
        try {
            this.queue.put(savingData);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return savingData.getFuture();
    }

    public CompletableFuture<T> loadData(E e) {
        LoadingData loadingData = new LoadingData(e);
        try {
            this.queue.put(loadingData);
        }
        catch (InterruptedException ex) {
            ex.printStackTrace();
        }
        return loadingData.getFuture();
    }

    public static class ProcessingData<T, E> {
    }

    private static class SavingData<T, E>
    extends ProcessingData<T, E> {
        private final T t;
        private final CompletableFuture<T> future;

        public SavingData(T t) {
            this.t = t;
            this.future = new CompletableFuture();
        }

        public T getObject() {
            return this.t;
        }

        public CompletableFuture<T> getFuture() {
            return this.future;
        }
    }

    private static class LoadingData<T, E>
    extends ProcessingData<T, E> {
        private final E e;
        private final CompletableFuture<T> future;

        public LoadingData(E e) {
            this.e = e;
            this.future = new CompletableFuture();
        }

        public E getId() {
            return this.e;
        }

        public CompletableFuture<T> getFuture() {
            return this.future;
        }
    }
}

