/*
 * Decompiled with CFR 0.152.
 */
package org.lushplugins.pvptoggle.libraries.pluginupdater.api.platform.hangar;

import com.google.common.io.CharStreams;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import org.lushplugins.pvptoggle.libraries.pluginupdater.api.platform.PlatformData;
import org.lushplugins.pvptoggle.libraries.pluginupdater.api.platform.hangar.HangarData;
import org.lushplugins.pvptoggle.libraries.pluginupdater.api.updater.PluginData;
import org.lushplugins.pvptoggle.libraries.pluginupdater.api.util.UpdaterConstants;
import org.lushplugins.pvptoggle.libraries.pluginupdater.api.version.VersionChecker;

public class HangarVersionChecker
implements VersionChecker {
    @Override
    public String getLatestVersion(PluginData pluginData, PlatformData platformData) throws IOException {
        if (!(platformData instanceof HangarData)) {
            return null;
        }
        HangarData hangarData = (HangarData)platformData;
        URL url = new URL("https://hangar.papermc.io/api/v1/projects/" + hangarData.getHangarProjectSlug() + "/latestrelease");
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.addRequestProperty("User-Agent", "PluginUpdater/" + UpdaterConstants.VERSION);
        if (connection.getResponseCode() != 200) {
            throw new IllegalStateException("Received invalid response code (" + connection.getResponseCode() + ") whilst getting the latest version for '" + pluginData.getPluginName() + "'.");
        }
        InputStream inputStream = connection.getInputStream();
        InputStreamReader reader = new InputStreamReader(inputStream);
        return CharStreams.toString((Readable)reader);
    }

    @Override
    public String getDownloadUrl(PluginData pluginData, PlatformData platformData) {
        String string;
        if (platformData instanceof HangarData) {
            HangarData hangarData = (HangarData)platformData;
            string = "https://hangar.papermc.io/api/v1/projects/" + hangarData.getHangarProjectSlug() + "/versions/" + pluginData.getLatestVersion() + "/PAPER/download";
        } else {
            string = null;
        }
        return string;
    }
}

