/*
 * Decompiled with CFR 0.152.
 */
package org.lushplugins.pvptoggle;

import org.bukkit.plugin.Plugin;
import org.lushplugins.pvptoggle.command.PvPCommand;
import org.lushplugins.pvptoggle.command.ToggleCommand;
import org.lushplugins.pvptoggle.command.UpdateCommand;
import org.lushplugins.pvptoggle.config.ConfigManager;
import org.lushplugins.pvptoggle.data.CooldownManager;
import org.lushplugins.pvptoggle.data.DataManager;
import org.lushplugins.pvptoggle.data.PvPUser;
import org.lushplugins.pvptoggle.hooks.WorldGuardHook;
import org.lushplugins.pvptoggle.libraries.lushlib.LushLib;
import org.lushplugins.pvptoggle.libraries.lushlib.hook.Hook;
import org.lushplugins.pvptoggle.libraries.lushlib.plugin.SpigotPlugin;
import org.lushplugins.pvptoggle.libraries.placeholderhandler.PlaceholderHandler;
import org.lushplugins.pvptoggle.libraries.pluginupdater.api.updater.Updater;
import org.lushplugins.pvptoggle.listeners.PlayerListener;
import org.lushplugins.pvptoggle.listeners.PvPListener;
import org.lushplugins.pvptoggle.placeholder.Placeholders;
import org.lushplugins.pvptoggle.util.lamp.response.StringMessageResponseHandler;
import revxrsal.commands.Lamp;
import revxrsal.commands.bukkit.BukkitLamp;
import revxrsal.commands.bukkit.actor.BukkitCommandActor;

public final class PvPToggle
extends SpigotPlugin {
    private static PvPToggle plugin;
    private CooldownManager cooldownManager;
    private ConfigManager configManager;
    private DataManager dataManager;
    private Updater updater;

    public void onLoad() {
        plugin = this;
        LushLib.getInstance().enable(this);
        this.ifPluginPresent("WorldGuard", () -> this.registerHook(new WorldGuardHook()));
    }

    public void onEnable() {
        this.cooldownManager = new CooldownManager();
        this.configManager = new ConfigManager();
        this.configManager.reloadConfig();
        this.dataManager = new DataManager();
        this.dataManager.enable();
        this.registerListeners(new PlayerListener(), new PvPListener());
        Lamp<BukkitCommandActor> lamp = BukkitLamp.builder(this).responseHandler(String.class, new StringMessageResponseHandler()).build();
        lamp.register(new PvPCommand(), new ToggleCommand());
        PlaceholderHandler.builder(this).registerParameterProvider(PvPUser.class, (type, parameter, context) -> PvPToggle.getInstance().getDataManager().getPvPUser(context.player())).registerParameterProvider(String.class, (type, parameter, context) -> parameter).build().register(new Placeholders());
        if (this.configManager.isUpdaterEnabled()) {
            this.updater = new Updater.Builder((Plugin)this).spigot("107427").checkSchedule(900L).notificationPermission("pvptoggle.update.notifications").notify(true).build();
            lamp.register(new UpdateCommand());
        }
    }

    public void onDisable() {
        if (this.dataManager != null) {
            this.dataManager.disable();
            this.dataManager = null;
        }
    }

    public CooldownManager getCooldownManager() {
        return this.cooldownManager;
    }

    public ConfigManager getConfigManager() {
        return this.configManager;
    }

    public DataManager getDataManager() {
        return this.dataManager;
    }

    public Updater getUpdater() {
        return this.updater;
    }

    @Override
    public void registerHook(Hook hook) {
        this.hooks.put(hook.getId(), hook);
        hook.enable();
    }

    public static PvPToggle getInstance() {
        return plugin;
    }
}

