/*
 * Decompiled with CFR 0.152.
 */
package org.lushplugins.pvptoggle.data;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.lushplugins.pvptoggle.PvPToggle;
import org.lushplugins.pvptoggle.config.ConfigManager;
import org.lushplugins.pvptoggle.data.PvPUser;
import org.lushplugins.pvptoggle.data.YmlStorage;
import org.lushplugins.pvptoggle.libraries.enchantedstorage.EnchantedStorage.IOHandler;
import org.lushplugins.pvptoggle.libraries.lushlib.manager.Manager;

public class DataManager
extends Manager {
    private IOHandler<PvPUser, UUID> ioHandler;
    private final HashMap<UUID, PvPUser> uuidToPvPUser = new HashMap();
    private final HashSet<UUID> pvpEnabledPlayers = new HashSet();

    @Override
    public void onEnable() {
        if (PvPToggle.getInstance().getConfigManager().isPvPStateRemembered()) {
            this.ioHandler = new IOHandler<PvPUser, UUID>(new YmlStorage());
            this.ioHandler.enable();
        }
    }

    @Override
    public void onDisable() {
        if (this.ioHandler != null) {
            this.ioHandler.disable();
            this.ioHandler = null;
        }
    }

    public PvPUser getPvPUser(@NotNull Player player) {
        UUID uuid = player.getUniqueId();
        PvPUser pvpUser = this.uuidToPvPUser.get(uuid);
        if (pvpUser == null) {
            pvpUser = new PvPUser(uuid, player.getName(), PvPToggle.getInstance().getConfigManager().getDefaultPvPState(), new ArrayList<UUID>());
            this.uuidToPvPUser.put(uuid, pvpUser);
        }
        return pvpUser;
    }

    public CompletableFuture<PvPUser> loadPvPUser(@NotNull Player player) {
        UUID uuid = player.getUniqueId();
        if (this.ioHandler == null) {
            PvPUser pvpUser2 = new PvPUser(uuid, player.getName(), PvPToggle.getInstance().getConfigManager().getDefaultPvPState(), new ArrayList<UUID>());
            this.uuidToPvPUser.put(uuid, pvpUser2);
            return CompletableFuture.completedFuture(pvpUser2);
        }
        return this.ioHandler.loadData(uuid).thenApply(pvpUser -> {
            ConfigManager configManager = PvPToggle.getInstance().getConfigManager();
            if (!configManager.isPvPStateRemembered()) {
                pvpUser.setPvPEnabled(configManager.getDefaultPvPState());
            }
            this.uuidToPvPUser.put(uuid, (PvPUser)pvpUser);
            if (pvpUser.isPvPEnabled()) {
                this.addPvPEnabledPlayer(uuid);
            }
            return pvpUser;
        });
    }

    public void unloadPvPUser(UUID uuid) {
        this.uuidToPvPUser.remove(uuid);
        this.removePvPEnabledPlayer(uuid);
    }

    public void savePvPUser(PvPUser user) {
        if (this.ioHandler != null) {
            this.ioHandler.saveData(user);
        }
    }

    public HashSet<UUID> getPvPEnabledPlayers() {
        return this.pvpEnabledPlayers;
    }

    public void addPvPEnabledPlayer(UUID uuid) {
        this.pvpEnabledPlayers.add(uuid);
    }

    public void removePvPEnabledPlayer(UUID uuid) {
        this.pvpEnabledPlayers.remove(uuid);
    }

    @Deprecated
    public IOHandler<PvPUser, UUID> getIoHandler() {
        return this.ioHandler;
    }
}

