/*
 * Decompiled with CFR 0.152.
 */
package org.lushplugins.pvptoggle.data;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import org.lushplugins.pvptoggle.PvPToggle;
import org.lushplugins.pvptoggle.data.DataManager;

public class PvPUser {
    private final UUID uuid;
    private String username;
    private boolean pvpEnabled;
    private Set<UUID> blockedUsers;

    @Deprecated
    public PvPUser(UUID uuid, String username, boolean pvpEnabled) {
        this(uuid, username, pvpEnabled, new HashSet<UUID>());
    }

    public PvPUser(UUID uuid, String username, boolean pvpEnabled, List<UUID> blockedUsers) {
        this(uuid, username, pvpEnabled, new HashSet<UUID>(blockedUsers));
    }

    public PvPUser(UUID uuid, String username, boolean pvpEnabled, Set<UUID> blockedUsers) {
        this.uuid = uuid;
        this.username = username;
        this.pvpEnabled = pvpEnabled;
        this.blockedUsers = blockedUsers;
    }

    public void setUsername(String username) {
        this.username = username;
        PvPToggle.getInstance().getDataManager().savePvPUser(this);
    }

    public void setPvPEnabled(boolean pvpEnabled) {
        this.pvpEnabled = pvpEnabled;
        DataManager dataManager = PvPToggle.getInstance().getDataManager();
        if (pvpEnabled) {
            dataManager.addPvPEnabledPlayer(this.uuid);
        } else {
            dataManager.removePvPEnabledPlayer(this.uuid);
        }
        dataManager.savePvPUser(this);
    }

    public UUID getUUID() {
        return this.uuid;
    }

    public String getUsername() {
        return this.username;
    }

    public boolean isPvPEnabled() {
        return this.pvpEnabled;
    }

    public String isPvPEnabledFriendly() {
        return this.pvpEnabled ? "enabled" : "disabled";
    }

    public Set<UUID> getBlockedUsers() {
        return this.blockedUsers;
    }

    public boolean hasBlockedUser(UUID uuid) {
        return this.blockedUsers.contains(uuid);
    }

    public void addBlockedUser(UUID uuid) {
        this.blockedUsers.add(uuid);
        PvPToggle.getInstance().getDataManager().savePvPUser(this);
    }

    public void removeBlockedUser(UUID uuid) {
        this.blockedUsers.remove(uuid);
        PvPToggle.getInstance().getDataManager().savePvPUser(this);
    }

    public void setBlockedUsers(List<UUID> blockedUsers) {
        this.blockedUsers = new HashSet<UUID>(blockedUsers);
        PvPToggle.getInstance().getDataManager().savePvPUser(this);
    }

    public boolean canPvPWith(@NotNull PvPUser user) {
        return this.pvpEnabled && user.isPvPEnabled() && !this.hasBlockedUser(user.getUUID()) && !user.hasBlockedUser(this.uuid);
    }

    public InteractionState canDamage(@NotNull PvPUser user) {
        if (user == this) {
            return InteractionState.SAME_PLAYER;
        }
        if (!this.pvpEnabled) {
            return InteractionState.ORIGIN_PVP_DISABLED;
        }
        if (!user.isPvPEnabled()) {
            return InteractionState.OTHER_PVP_DISABLED;
        }
        if (user.hasBlockedUser(this.uuid)) {
            return InteractionState.ORIGIN_BLOCKED;
        }
        if (this.hasBlockedUser(user.getUUID())) {
            return InteractionState.OTHER_BLOCKED;
        }
        return InteractionState.ALLOWED;
    }

    public static enum InteractionState {
        ALLOWED,
        ORIGIN_PVP_DISABLED,
        ORIGIN_BLOCKED,
        OTHER_PVP_DISABLED,
        OTHER_BLOCKED,
        SAME_PLAYER;

    }
}

