/*
 * Decompiled with CFR 0.152.
 */
package org.lushplugins.pvptoggle.libraries.lushlib.module;

import java.util.logging.Level;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.lushplugins.pvptoggle.libraries.lushlib.LushLib;
import org.lushplugins.pvptoggle.libraries.lushlib.LushLogger;

public abstract class Module {
    protected final String id;
    private boolean enabled = false;

    public Module(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    protected void onEnable() {
    }

    public final void enable() {
        if (!this.enabled) {
            Module module;
            this.enabled = true;
            try {
                this.onEnable();
            }
            catch (Throwable e) {
                LushLogger.getLogger().log(Level.SEVERE, "Error when enabling module '%s' at: ".formatted(this.id), e);
                LushLogger.getLogger().log(Level.SEVERE, "Disabling module '%s'".formatted(this.id));
                this.disable();
                return;
            }
            if (this.enabled && (module = this) instanceof Listener) {
                Listener listener = (Listener)module;
                LushLib.getInstance().getPlugin().getServer().getPluginManager().registerEvents(listener, (Plugin)LushLib.getInstance().getPlugin());
            }
            LushLogger.getLogger().log(Level.INFO, "Successfully enabled module '%s'".formatted(this.id));
        }
    }

    protected void onDisable() {
    }

    public final void disable() {
        Module module;
        this.enabled = false;
        try {
            this.onDisable();
        }
        catch (Throwable e) {
            LushLogger.getLogger().log(Level.SEVERE, "Error when disabling module '%s' at: ".formatted(this.id), e);
        }
        if (!this.enabled && (module = this) instanceof Listener) {
            Listener listener = (Listener)module;
            HandlerList.unregisterAll((Listener)listener);
        }
    }

    public final void reload() {
        if (this.enabled) {
            this.disable();
        }
        this.enable();
    }
}

