/*
 * Decompiled with CFR 0.152.
 */
package org.lushplugins.pvptoggle.libraries.pluginupdater.api.platform.modrinth;

import java.util.EnumSet;
import java.util.stream.Collectors;
import org.bukkit.configuration.ConfigurationSection;
import org.jetbrains.annotations.Nullable;
import org.lushplugins.pvptoggle.libraries.pluginupdater.api.platform.PlatformData;

public class ModrinthData
extends PlatformData {
    private static final String NAME = "modrinth";
    private final String modrinthProjectId;
    @Nullable
    private final EnumSet<VersionType> versionTypes;
    private final boolean featuredOnly;

    public ModrinthData(ConfigurationSection configurationSection) {
        super(NAME);
        this.modrinthProjectId = configurationSection.getString("modrinth-project-id");
        this.versionTypes = configurationSection.isString("channels") ? EnumSet.of(VersionType.valueOf(configurationSection.getString("channels", "release").toUpperCase())) : (configurationSection.isList("channels") ? configurationSection.getStringList("channels").stream().map(channelRaw -> VersionType.valueOf(channelRaw.toUpperCase())).collect(Collectors.toCollection(() -> EnumSet.noneOf(VersionType.class))) : null);
        this.featuredOnly = configurationSection.getBoolean("featured-only");
    }

    public ModrinthData(String modrinthProjectId, boolean featuredOnly) {
        this(modrinthProjectId, null, featuredOnly);
    }

    public ModrinthData(String modrinthProjectId, @Nullable EnumSet<VersionType> versionTypes, boolean featuredOnly) {
        super(NAME);
        this.modrinthProjectId = modrinthProjectId;
        this.versionTypes = versionTypes;
        this.featuredOnly = featuredOnly;
    }

    public String getModrinthProjectId() {
        return this.modrinthProjectId;
    }

    @Nullable
    public EnumSet<VersionType> getVersionTypes() {
        return this.versionTypes;
    }

    public boolean includeFeaturedOnly() {
        return this.featuredOnly;
    }

    public static enum VersionType {
        RELEASE,
        BETA,
        ALPHA;

    }
}

