/*
 * Decompiled with CFR 0.152.
 */
package org.lushplugins.chatcolorhandler;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lushplugins.chatcolorhandler.ChatColorHandler;
import org.lushplugins.chatcolorhandler.parsers.Parsers;
import org.lushplugins.chatcolorhandler.parsers.custom.HexParser;
import org.lushplugins.chatcolorhandler.parsers.custom.LegacyCharParser;
import org.lushplugins.chatcolorhandler.parsers.custom.MiniMessageParser;
import org.lushplugins.chatcolorhandler.parsers.custom.Parser;
import org.lushplugins.chatcolorhandler.parsers.custom.PlaceholderAPIParser;
import org.lushplugins.chatcolorhandler.resolvers.Resolver;
import org.lushplugins.chatcolorhandler.resolvers.Resolvers;

public class ModernChatColorHandler {
    public static Component translate(@Nullable String string) {
        return ModernChatColorHandler.translate(string, null, null, null);
    }

    public static Component translate(@Nullable String string, List<Class<? extends Parser>> parsers) {
        return ModernChatColorHandler.translate(string, null, parsers, null);
    }

    public static Component translate(@Nullable String string, Player player) {
        return ModernChatColorHandler.translate(string, player, null, null);
    }

    public static Component translate(@Nullable String string, Player player, List<Class<? extends Parser>> parsers) {
        return ModernChatColorHandler.translate(string, player, parsers, null);
    }

    public static Component translate(@Nullable String string, Player player, List<Class<? extends Parser>> parsers, List<Class<? extends Resolver>> resolvers) {
        boolean parseHex;
        if (string == null || string.isBlank()) {
            return Component.empty();
        }
        if (parsers == null) {
            parseHex = true;
            parsers = List.of(LegacyCharParser.class, PlaceholderAPIParser.class);
        } else {
            parsers = new ArrayList<Class<? extends Parser>>(parsers);
            parseHex = parsers.remove(HexParser.class);
            parsers.remove(MiniMessageParser.class);
        }
        String legacyParsed = MiniMessageParser.legacyToMiniMessage(Parsers.parseString(string, player, parsers), parseHex);
        return MiniMessage.miniMessage().deserialize(legacyParsed, Resolvers.getResolver((Audience)player, resolvers));
    }

    public static List<Component> translate(@NotNull Collection<String> strings) {
        return strings.stream().map(ModernChatColorHandler::translate).toList();
    }

    public static List<Component> translate(@NotNull Collection<String> strings, List<Class<? extends Parser>> parsers) {
        return strings.stream().map(string -> ModernChatColorHandler.translate(string, parsers)).toList();
    }

    public static List<Component> translate(@NotNull Collection<String> strings, Player player) {
        return strings.stream().map(string -> ModernChatColorHandler.translate(string, player)).toList();
    }

    public static List<Component> translate(@NotNull Collection<String> strings, Player player, List<Class<? extends Parser>> parsers) {
        return strings.stream().map(string -> ModernChatColorHandler.translate(string, player, parsers)).toList();
    }

    @Deprecated(forRemoval=true)
    public static Component translateAlternateColorCodes(@Nullable String string) {
        return ModernChatColorHandler.translate(string, null, null, null);
    }

    @Deprecated(forRemoval=true)
    public static Component translateAlternateColorCodes(@Nullable String string, List<Class<? extends Parser>> parsers) {
        return ModernChatColorHandler.translate(string, null, parsers, null);
    }

    @Deprecated(forRemoval=true)
    public static Component translateAlternateColorCodes(@Nullable String string, Player player) {
        return ModernChatColorHandler.translate(string, player, null, null);
    }

    @Deprecated(forRemoval=true)
    public static Component translateAlternateColorCodes(@Nullable String string, Player player, List<Class<? extends Parser>> parsers) {
        return ModernChatColorHandler.translate(string, player, parsers, null);
    }

    @Deprecated(forRemoval=true)
    public static Component translateAlternateColorCodes(@Nullable String string, Player player, List<Class<? extends Parser>> parsers, List<Class<? extends Resolver>> resolvers) {
        return ModernChatColorHandler.translate(string, player, parsers, resolvers);
    }

    static {
        ChatColorHandler.translate("init");
    }
}

