/*
 * Decompiled with CFR 0.152.
 */
package org.lushplugins.pvptoggle.config;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.lushplugins.pvptoggle.PvPToggle;
import org.lushplugins.pvptoggle.hooks.WorldGuardHook;
import org.lushplugins.pvptoggle.libraries.lushlib.libraries.chatcolor.ChatColorHandler;

public class ConfigManager {
    private static final Pattern OUTDATED_MESSAGE_NAME = Pattern.compile("[A-Z_]");
    private boolean rememberPvPState;
    private long commandCooldown;
    private long pvpCooldown;
    private int commandWaitTime;
    private boolean defaultPvPState;
    private int particlesDisplayMode;
    private List<String> ignoredWorlds = new ArrayList<String>();
    private String placeholderPvPEnabled;
    private String placeholderPvPDisabled;
    private boolean enableUpdater;
    private final ConcurrentHashMap<String, String> messages = new ConcurrentHashMap();

    public ConfigManager() {
        PvPToggle.getInstance().saveDefaultConfig();
    }

    public void reloadConfig() {
        PvPToggle plugin = PvPToggle.getInstance();
        plugin.reloadConfig();
        FileConfiguration config = plugin.getConfig();
        this.rememberPvPState = config.getBoolean("remember-pvp-state", true);
        this.commandCooldown = config.getLong("command-cooldown", 0L);
        this.pvpCooldown = config.getLong("pvp-cooldown", 0L);
        this.commandWaitTime = config.getInt("command-wait", 0);
        this.defaultPvPState = config.getBoolean("default-pvp", true);
        this.particlesDisplayMode = config.getInt("particles", -1);
        this.ignoredWorlds = new ArrayList<String>(config.getStringList("ignored-worlds"));
        if (config.contains("worlds")) {
            this.ignoredWorlds.addAll(config.getStringList("worlds"));
            plugin.getLogger().warning("Deprecated: The 'worlds' config option has been renamed to 'ignored-worlds' and is scheduled for removal");
        }
        this.placeholderPvPEnabled = config.getString("placeholder-api.pvp-enabled");
        this.placeholderPvPDisabled = config.getString("placeholder-api.pvp-disabled");
        this.enableUpdater = config.getBoolean("enable-updater", true);
        this.messages.clear();
        ConfigurationSection messagesSection = config.getConfigurationSection("messages");
        if (messagesSection != null) {
            messagesSection.getValues(false).forEach((key, value) -> {
                if (OUTDATED_MESSAGE_NAME.matcher((CharSequence)key).find()) {
                    plugin.getLogger().warning("Deprecated: The message '" + key + "' contains uppercase or underscore characters which are no longer used in message names and are scheduled for removal. Please note that message names and placeholders were changed in version 2 and will need adjusting");
                    key = key.toLowerCase().replace("_", "-").replace("others", "other");
                }
                this.messages.put((String)key, (String)value);
            });
        }
    }

    public boolean isPvPStateRemembered() {
        return this.rememberPvPState;
    }

    public long getCommandCooldown() {
        return this.commandCooldown;
    }

    public long getPvPCooldown() {
        return this.pvpCooldown;
    }

    public int getCommandWaitTime() {
        return this.commandWaitTime;
    }

    public boolean getDefaultPvPState() {
        return this.defaultPvPState;
    }

    public int getParticlesDisplayMode() {
        return this.particlesDisplayMode;
    }

    public boolean isLocationIgnored(World world, Location location) {
        if (this.isWorldIgnored(world.getName())) {
            return true;
        }
        Object var4_3 = PvPToggle.getInstance().getHook("WorldGuard").orElse(null);
        if (var4_3 instanceof WorldGuardHook) {
            WorldGuardHook worldGuardHook = var4_3;
            return !worldGuardHook.isRegionEnabled(world, location);
        }
        return false;
    }

    public boolean isWorldIgnored(String worldName) {
        return this.ignoredWorlds.contains(worldName);
    }

    public String getPvPEnabledPlaceholder() {
        return this.placeholderPvPEnabled;
    }

    public String getPvPDisabledPlaceholder() {
        return this.placeholderPvPDisabled;
    }

    public boolean isUpdaterEnabled() {
        return this.enableUpdater;
    }

    public String getMessage(String messageName) {
        String message = this.messages.get(messageName);
        if (message == null || message.isBlank()) {
            return null;
        }
        return message.replace("%prefix%", this.messages.getOrDefault("prefix", ""));
    }

    public void sendMessage(CommandSender sender, String messageName) {
        ChatColorHandler.sendMessage(sender, this.getMessage(messageName));
    }
}

