/*
 * Decompiled with CFR 0.152.
 */
package org.lushplugins.pvptoggle.data;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.lushplugins.pvptoggle.PvPToggle;
import org.lushplugins.pvptoggle.data.PvPUser;
import org.lushplugins.pvptoggle.libraries.enchantedstorage.EnchantedStorage.Storage;

public class YmlStorage
implements Storage<PvPUser, UUID> {
    private final File dataFolder = new File(PvPToggle.getInstance().getDataFolder(), "data");

    @Override
    public PvPUser load(UUID uuid) {
        YamlConfiguration configurationSection = this.loadOrCreateFile(uuid);
        return new PvPUser(uuid, configurationSection.getString("name"), configurationSection.getBoolean("pvp-enabled"), configurationSection.getStringList("blocked-users").stream().map(UUID::fromString).collect(Collectors.toSet()));
    }

    @Override
    public void save(PvPUser pvpUser) {
        YamlConfiguration yamlConfiguration = this.loadOrCreateFile(pvpUser.getUUID());
        String username = pvpUser.getUsername();
        if (username != null) {
            yamlConfiguration.set("name", (Object)username);
        }
        yamlConfiguration.set("pvp-enabled", (Object)pvpUser.isPvPEnabled());
        yamlConfiguration.set("blocked-users", pvpUser.getBlockedUsers().stream().map(UUID::toString).toList());
        File file = new File(this.dataFolder, pvpUser.getUUID().toString() + ".yml");
        try {
            yamlConfiguration.save(file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private YamlConfiguration loadOrCreateFile(UUID uuid) {
        File file = new File(this.dataFolder, uuid.toString() + ".yml");
        YamlConfiguration yamlConfiguration = YamlConfiguration.loadConfiguration((File)file);
        if (yamlConfiguration.getString("name") == null) {
            Player player = Bukkit.getPlayer((UUID)uuid);
            String username = player != null ? player.getName() : "Error: Could not get username, will load when the player next joins";
            yamlConfiguration.set("name", (Object)username);
            yamlConfiguration.set("pvp-enabled", (Object)PvPToggle.getInstance().getConfigManager().getDefaultPvPState());
            yamlConfiguration.set("blocked-users", Collections.emptyList());
            try {
                yamlConfiguration.save(file);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return yamlConfiguration;
    }
}

