/*
 * Decompiled with CFR 0.152.
 */
package org.lushplugins.pvptoggle.libraries.placeholderhandler;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.Nullable;
import org.lushplugins.pvptoggle.libraries.placeholderhandler.annotation.AnnotationHandler;
import org.lushplugins.pvptoggle.libraries.placeholderhandler.hook.HookRegistry;
import org.lushplugins.pvptoggle.libraries.placeholderhandler.hook.PlaceholderAPIHook;
import org.lushplugins.pvptoggle.libraries.placeholderhandler.parameter.EmbeddedPlaceholderProvider;
import org.lushplugins.pvptoggle.libraries.placeholderhandler.parameter.ParameterProvider;
import org.lushplugins.pvptoggle.libraries.placeholderhandler.placeholder.PlaceholderContext;
import org.lushplugins.pvptoggle.libraries.placeholderhandler.placeholder.PlaceholderImpl;
import org.lushplugins.pvptoggle.libraries.placeholderhandler.placeholder.PlaceholderParser;
import org.lushplugins.pvptoggle.libraries.placeholderhandler.placeholder.node.LiteralNode;
import org.lushplugins.pvptoggle.libraries.placeholderhandler.placeholder.node.PlaceholderNode;
import org.lushplugins.pvptoggle.libraries.placeholderhandler.stream.StringStream;

public final class PlaceholderHandler {
    private final JavaPlugin plugin;
    private final List<PlaceholderImpl> placeholders = new ArrayList<PlaceholderImpl>();
    private final Map<Class<?>, ParameterProvider<?>> parameterProviders;
    private final Map<Class<?>, ParameterProvider.Factory> parameterProviderFactories;
    private final HookRegistry hooks = new HookRegistry();

    public PlaceholderHandler(JavaPlugin plugin, Map<Class<?>, ParameterProvider<?>> parameterProviders, Map<Class<?>, ParameterProvider.Factory> parameterProviderFactories) {
        this.plugin = plugin;
        this.parameterProviders = parameterProviders;
        this.parameterProviderFactories = parameterProviderFactories;
        this.hooks.register("PlaceholderAPI", () -> new PlaceholderAPIHook());
    }

    public JavaPlugin plugin() {
        return this.plugin;
    }

    public List<PlaceholderImpl> placeholders() {
        return this.placeholders;
    }

    public void register(Object instance) {
        if (instance instanceof PlaceholderImpl) {
            PlaceholderImpl placeholder = (PlaceholderImpl)instance;
            this.placeholders.add(placeholder);
            this.hooks.registerPlaceholder(this, placeholder);
            return;
        }
        List<PlaceholderImpl> placeholders = AnnotationHandler.register(instance.getClass(), instance, this);
        this.placeholders.addAll(placeholders);
        this.hooks.registerPlaceholders(this, placeholders);
    }

    public void register(String rawPlaceholder, PlaceholderParser placeholder) {
        List<PlaceholderNode> nodes = Arrays.stream(rawPlaceholder.substring(1, rawPlaceholder.length() - 1).split("_")).map(parameter -> new LiteralNode((String)parameter)).toList();
        this.register(new PlaceholderImpl(nodes, placeholder));
    }

    @Nullable
    public String parsePlaceholder(String rawPlaceholder, @Nullable Player player) {
        StringStream input = StringStream.create(rawPlaceholder.substring(1, rawPlaceholder.length() - 1));
        PlaceholderContext context = new PlaceholderContext(input, player, this);
        String identifier = input.peekUnquotedString();
        for (PlaceholderImpl placeholder : this.placeholders) {
            if (!placeholder.firstNode().name().equals(identifier) || !placeholder.isValid(input.toMutableCopy(), context)) continue;
            return placeholder.parse(input.toMutableCopy(), context);
        }
        return null;
    }

    public ParameterProvider<?> getParameterProvider(Class<?> type) {
        return this.parameterProviders.get(type);
    }

    public ParameterProvider.Factory getParameterProviderFactory(Class<?> type) {
        return this.parameterProviderFactories.get(type);
    }

    public static Builder builder(JavaPlugin plugin) {
        return new Builder(plugin);
    }

    public static class Builder {
        private final JavaPlugin plugin;
        private final Map<Class<?>, ParameterProvider<?>> parameterProviders = new HashMap(Map.ofEntries(ParameterProvider.forType(Player.class, (type, parameter, context) -> context.player())));
        private final Map<Class<?>, ParameterProvider.Factory> parameterProviderFactories = new HashMap(Map.ofEntries(ParameterProvider.Factory.forType(String.class, new EmbeddedPlaceholderProvider())));

        private Builder(JavaPlugin plugin) {
            this.plugin = plugin;
        }

        public <T> Builder registerParameterProvider(Class<T> type, ParameterProvider<T> provider) {
            this.parameterProviders.put(type, provider);
            return this;
        }

        public Builder registerParameterProviderFactory(Class<?> type, ParameterProvider.Factory provider) {
            this.parameterProviderFactories.put(type, provider);
            return this;
        }

        public PlaceholderHandler build() {
            return new PlaceholderHandler(this.plugin, this.parameterProviders, this.parameterProviderFactories);
        }
    }
}

