/*
 * Decompiled with CFR 0.152.
 */
package org.lushplugins.pvptoggle.libraries.pluginupdater.api.platform.github;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import org.lushplugins.pvptoggle.libraries.pluginupdater.api.platform.PlatformData;
import org.lushplugins.pvptoggle.libraries.pluginupdater.api.platform.github.GithubData;
import org.lushplugins.pvptoggle.libraries.pluginupdater.api.updater.PluginData;
import org.lushplugins.pvptoggle.libraries.pluginupdater.api.util.UpdaterConstants;
import org.lushplugins.pvptoggle.libraries.pluginupdater.api.version.VersionChecker;

public class GithubVersionChecker
implements VersionChecker {
    @Override
    public String getLatestVersion(PluginData pluginData, PlatformData platformData) throws IOException {
        if (!(platformData instanceof GithubData)) {
            return null;
        }
        GithubData githubData = (GithubData)platformData;
        URL url = new URL("https://api.github.com/repos/" + githubData.getGithubRepo() + "/releases/latest");
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.addRequestProperty("User-Agent", "PluginUpdater/" + UpdaterConstants.VERSION);
        if (connection.getResponseCode() != 200) {
            throw new IllegalStateException("Received invalid response code (" + connection.getResponseCode() + ") whilst getting the latest version for '" + pluginData.getPluginName() + "'.");
        }
        InputStream inputStream = connection.getInputStream();
        InputStreamReader reader = new InputStreamReader(inputStream);
        JsonObject releaseJson = JsonParser.parseReader((Reader)reader).getAsJsonObject();
        return releaseJson.get("tag_name").getAsString();
    }

    @Override
    public String getDownloadUrl(PluginData pluginData, PlatformData platformData) throws IOException {
        if (!(platformData instanceof GithubData)) {
            return null;
        }
        GithubData githubData = (GithubData)platformData;
        URL url = new URL("https://api.github.com/repos/" + githubData.getGithubRepo() + "/releases/latest");
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.addRequestProperty("User-Agent", "PluginUpdater/" + UpdaterConstants.VERSION);
        if (connection.getResponseCode() != 200) {
            throw new IllegalStateException("Received invalid response code (" + connection.getResponseCode() + ") whilst getting the latest version for '" + pluginData.getPluginName() + "'.");
        }
        InputStream inputStream = connection.getInputStream();
        InputStreamReader reader = new InputStreamReader(inputStream);
        JsonObject releaseJson = JsonParser.parseReader((Reader)reader).getAsJsonObject();
        JsonArray assetsJson = releaseJson.get("assets").getAsJsonArray();
        return assetsJson.get(0).getAsJsonObject().get("browser_download_url").getAsString();
    }
}

