/*
 * Decompiled with CFR 0.152.
 */
package org.lushplugins.pvptoggle.libraries.pluginupdater.api.updater;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import java.util.regex.Matcher;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lushplugins.pvptoggle.libraries.pluginupdater.api.listener.NotificationHandler;
import org.lushplugins.pvptoggle.libraries.pluginupdater.api.platform.PlatformData;
import org.lushplugins.pvptoggle.libraries.pluginupdater.api.platform.github.GithubData;
import org.lushplugins.pvptoggle.libraries.pluginupdater.api.platform.hangar.HangarData;
import org.lushplugins.pvptoggle.libraries.pluginupdater.api.platform.modrinth.ModrinthData;
import org.lushplugins.pvptoggle.libraries.pluginupdater.api.platform.spigot.SpigotData;
import org.lushplugins.pvptoggle.libraries.pluginupdater.api.updater.PluginData;
import org.lushplugins.pvptoggle.libraries.pluginupdater.api.util.DownloadLogger;
import org.lushplugins.pvptoggle.libraries.pluginupdater.api.version.VersionChecker;
import org.lushplugins.pvptoggle.libraries.pluginupdater.api.version.VersionDifference;

public class Updater {
    private final Plugin plugin;
    private final PluginData pluginData;
    private final NotificationHandler notificationHandler;

    private Updater(@NotNull Plugin plugin, @NotNull PluginData pluginData, boolean notify, String notificationPermission, String notificationMessage) {
        this.plugin = plugin;
        this.pluginData = pluginData;
        this.notificationHandler = notify ? new NotificationHandler(this, notificationPermission, notificationMessage) : null;
    }

    public Plugin getPlugin() {
        return this.plugin;
    }

    public PluginData getPluginData() {
        return this.pluginData;
    }

    public NotificationHandler getNotificationHandler() {
        return this.notificationHandler;
    }

    public boolean isUpdateAvailable() {
        return this.pluginData.isUpdateAvailable();
    }

    public boolean isAlreadyDownloaded() {
        return this.pluginData.isAlreadyDownloaded();
    }

    public CompletableFuture<Boolean> checkForUpdate() {
        CompletableFuture<Boolean> completableFuture = new CompletableFuture<Boolean>();
        Bukkit.getScheduler().runTaskAsynchronously(this.plugin, () -> {
            try {
                String currentVersion = this.pluginData.getCurrentVersion();
                Matcher matcher = VersionChecker.VERSION_PATTERN.matcher(VersionChecker.getLatestVersion(this.pluginData));
                if (!matcher.find()) {
                    completableFuture.complete(false);
                    return;
                }
                String latestVersion = matcher.group();
                this.pluginData.setCheckRan(true);
                VersionDifference versionDifference = VersionDifference.getVersionDifference(currentVersion, latestVersion);
                if (!versionDifference.equals((Object)VersionDifference.LATEST)) {
                    this.pluginData.setLatestVersion(latestVersion);
                    this.pluginData.setVersionDifference(versionDifference);
                    completableFuture.complete(true);
                } else {
                    completableFuture.complete(false);
                }
            }
            catch (IOException | IllegalStateException e) {
                this.plugin.getLogger().severe(e.getMessage());
                completableFuture.complete(false);
            }
        });
        return completableFuture;
    }

    public CompletableFuture<Boolean> attemptDownload() {
        if (!this.pluginData.isEnabled() || !this.pluginData.isUpdateAvailable() || this.pluginData.isAlreadyDownloaded()) {
            return CompletableFuture.completedFuture(false);
        }
        return this.download();
    }

    public CompletableFuture<Boolean> forceDownload() {
        return this.download();
    }

    private CompletableFuture<Boolean> download() {
        CompletableFuture<Boolean> completableFuture = new CompletableFuture<Boolean>();
        Bukkit.getScheduler().runTaskAsynchronously(this.plugin, () -> {
            try {
                if (VersionChecker.download(this.pluginData)) {
                    this.pluginData.setVersionDifference(VersionDifference.UNKNOWN);
                    this.pluginData.setAlreadyDownloaded(true);
                    completableFuture.complete(true);
                } else {
                    completableFuture.complete(false);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                completableFuture.completeExceptionally(e);
            }
        });
        return completableFuture;
    }

    public static class Builder {
        private final Plugin plugin;
        private final PluginData pluginData;
        private long checkFrequency = 600L;
        private boolean notify = true;
        private String notificationPermission = "pluginupdater.notifications";
        private String notificationMessage = "&#ffe27aA new &#e0c01b%plugin% &#ffe27aupdate is now available! &#e0c01b%current_version% &#ffe27a-> &#e0c01b%latest_version%";
        private File downloadLogFile;

        public Builder(Plugin plugin) {
            this.plugin = plugin;
            this.pluginData = new PluginData(plugin, new ArrayList<PlatformData>());
        }

        public Builder github(String githubRepo) {
            return this.platform(new GithubData(githubRepo));
        }

        public Builder hangar(String hangarProjectSlug) {
            return this.platform(new HangarData(hangarProjectSlug));
        }

        public Builder modrinth(String modrinthProjectId, boolean featuredOnly) {
            return this.platform(new ModrinthData(modrinthProjectId, featuredOnly));
        }

        public Builder spigot(String spigotResourceId) {
            return this.platform(new SpigotData(spigotResourceId));
        }

        public Builder platform(PlatformData platformData) {
            this.pluginData.addPlatform(platformData);
            return this;
        }

        public Builder checkSchedule(long seconds) {
            this.checkFrequency = seconds;
            return this;
        }

        public Builder notify(boolean shouldSend) {
            this.notify = shouldSend;
            return this;
        }

        public Builder notificationPermission(@Nullable String permission) {
            this.notificationPermission = permission;
            return this;
        }

        public Builder notificationMessage(@NotNull String message) {
            this.notificationMessage = message;
            return this;
        }

        public Builder logDownloads(@Nullable File logFile) {
            this.downloadLogFile = logFile;
            return this;
        }

        public Updater build() {
            if (this.pluginData.getPlatformData().isEmpty()) {
                throw new IllegalStateException("At least 1 platform must be registered before building the Updater.");
            }
            DownloadLogger.setLogFile(this.downloadLogFile);
            Updater updater = new Updater(this.plugin, this.pluginData, this.notify, this.notificationPermission, this.notificationMessage);
            if (this.checkFrequency > 0L) {
                Bukkit.getScheduler().runTaskTimerAsynchronously(this.plugin, updater::checkForUpdate, 0L, this.checkFrequency * 20L);
            }
            return updater;
        }
    }
}

