/*
 * Decompiled with CFR 0.152.
 */
package org.lushplugins.pvptoggle.listeners;

import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.damage.DamageSource;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LightningStrike;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.AreaEffectCloudApplyEvent;
import org.bukkit.event.entity.EntityCombustByEntityEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.PotionSplashEvent;
import org.bukkit.event.player.PlayerFishEvent;
import org.bukkit.projectiles.ProjectileSource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lushplugins.pvptoggle.PvPToggle;
import org.lushplugins.pvptoggle.api.PvPToggleAPI;
import org.lushplugins.pvptoggle.data.CooldownManager;
import org.lushplugins.pvptoggle.data.PvPUser;
import org.lushplugins.pvptoggle.libraries.lushlib.libraries.chatcolor.ChatColorHandler;

public class PvPListener
implements Listener {
    @EventHandler(ignoreCancelled=true)
    public void onEntityDamageEvent(EntityDamageByEntityEvent event) {
        Player damagerPlayer;
        Entity entity;
        if (PvPToggle.getInstance().getConfigManager().isLocationIgnored(event.getEntity().getWorld(), event.getEntity().getLocation())) {
            return;
        }
        Entity entity2 = event.getEntity();
        if (!(entity2 instanceof Player)) {
            return;
        }
        Player damagedPlayer = (Player)entity2;
        PvPUser damagedUser = this.getPvPUserFromEntity((Entity)damagedPlayer);
        if (damagedUser == null) {
            return;
        }
        if (event.getDamager().hasMetadata(PvPToggleAPI.getMetadataKey())) {
            if (damagedUser.isPvPEnabled()) {
                event.setCancelled(true);
            }
            return;
        }
        DamageSource source = event.getDamageSource();
        Entity damagerEntity = source.getCausingEntity();
        boolean silent = false;
        if (damagerEntity == null && (entity = event.getDamager()) instanceof LightningStrike) {
            LightningStrike lightning = (LightningStrike)entity;
            damagerEntity = lightning.getCausingPlayer();
            silent = true;
        }
        if (!(damagerEntity instanceof Player) || (damagerPlayer = (Player)damagerEntity) == damagedPlayer) {
            return;
        }
        this.allowOrCancel(damagerPlayer, damagedPlayer, (Cancellable)event, silent);
    }

    @EventHandler(ignoreCancelled=true)
    public void onFlameArrow(EntityCombustByEntityEvent event) {
        Player damagerPlayer;
        ProjectileSource projectileSource;
        block6: {
            block5: {
                if (PvPToggle.getInstance().getConfigManager().isLocationIgnored(event.getEntity().getWorld(), event.getEntity().getLocation())) {
                    return;
                }
                Entity entity = event.getCombuster();
                if (!(entity instanceof Arrow)) {
                    return;
                }
                Arrow arrow = (Arrow)entity;
                projectileSource = arrow.getShooter();
                if (!(projectileSource instanceof Player)) break block5;
                damagerPlayer = (Player)projectileSource;
                projectileSource = event.getEntity();
                if (projectileSource instanceof Player) break block6;
            }
            return;
        }
        Player damagedPlayer = (Player)projectileSource;
        this.allowOrCancel(damagerPlayer, damagedPlayer, (Cancellable)event);
    }

    @EventHandler(ignoreCancelled=true)
    public void onPotionSplash(PotionSplashEvent event) {
        if (PvPToggle.getInstance().getConfigManager().isLocationIgnored(event.getEntity().getWorld(), event.getEntity().getLocation())) {
            return;
        }
        ProjectileSource projectileSource = event.getPotion().getShooter();
        if (!(projectileSource instanceof Player)) {
            return;
        }
        Player damagerPlayer = (Player)projectileSource;
        boolean damagerHasPvPEnabled = PvPToggle.getInstance().getDataManager().getPvPUser(damagerPlayer).isPvPEnabled();
        if (!damagerHasPvPEnabled) {
            for (LivingEntity entity : event.getAffectedEntities()) {
                Player effected;
                if (!(entity instanceof Player) || damagerPlayer == (effected = (Player)entity)) continue;
                event.setIntensity((LivingEntity)effected, 0.0);
            }
            PvPToggle.getInstance().getConfigManager().sendMessage((CommandSender)damagerPlayer, "pvp-disabled");
            return;
        }
        for (LivingEntity entity : event.getAffectedEntities()) {
            Player damagedPlayer;
            if (!(entity instanceof Player) || damagerPlayer == (damagedPlayer = (Player)entity)) continue;
            PvPUser damaged = PvPToggle.getInstance().getDataManager().getPvPUser(damagedPlayer);
            if (!damaged.isPvPEnabled()) {
                event.setIntensity((LivingEntity)damagedPlayer, 0.0);
                ChatColorHandler.sendMessage((CommandSender)damagerPlayer, PvPToggle.getInstance().getConfigManager().getMessage("pvp-disabled-other").replace("%player%", damagedPlayer.getName()));
                continue;
            }
            PvPToggle.getInstance().getCooldownManager().setCooldown(damagerPlayer, CooldownManager.CooldownType.PVP);
            PvPToggle.getInstance().getCooldownManager().setCooldown(damagedPlayer, CooldownManager.CooldownType.PVP);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onCloudEffects(AreaEffectCloudApplyEvent event) {
        if (PvPToggle.getInstance().getConfigManager().isLocationIgnored(event.getEntity().getWorld(), event.getEntity().getLocation())) {
            return;
        }
        ProjectileSource projectileSource = event.getEntity().getSource();
        if (!(projectileSource instanceof Player)) {
            return;
        }
        Player damagerPlayer = (Player)projectileSource;
        PvPUser damager = PvPToggle.getInstance().getDataManager().getPvPUser(damagerPlayer);
        if (!damager.isPvPEnabled()) {
            event.getAffectedEntities().removeIf(damagedEntity -> {
                Player damagedPlayer;
                return !(damagedEntity instanceof Player) || damagerPlayer == (damagedPlayer = (Player)damagedEntity);
            });
            return;
        }
        event.getAffectedEntities().removeIf(entity -> {
            Player damagedPlayer;
            if (!(entity instanceof Player) || (damagedPlayer = (Player)entity) == damagerPlayer) {
                return false;
            }
            PvPUser damaged = PvPToggle.getInstance().getDataManager().getPvPUser(damagedPlayer);
            if (!damaged.isPvPEnabled()) {
                return true;
            }
            PvPToggle.getInstance().getCooldownManager().setCooldown(damagerPlayer, CooldownManager.CooldownType.PVP);
            PvPToggle.getInstance().getCooldownManager().setCooldown(damagedPlayer, CooldownManager.CooldownType.PVP);
            return false;
        });
    }

    @EventHandler(ignoreCancelled=true)
    public void onPlayerFishing(PlayerFishEvent event) {
        Entity caught = event.getCaught();
        if (caught == null || PvPToggle.getInstance().getConfigManager().isLocationIgnored(caught.getWorld(), caught.getLocation())) {
            return;
        }
        Player damagerPlayer = event.getPlayer();
        if (!(caught instanceof Player)) {
            return;
        }
        Player damagedPlayer = (Player)caught;
        if (damagerPlayer.getInventory().getItemInMainHand().getType() != Material.FISHING_ROD && damagerPlayer.getInventory().getItemInOffHand().getType() != Material.FISHING_ROD) {
            return;
        }
        this.allowOrCancel(damagerPlayer, damagedPlayer, (Cancellable)event);
    }

    private void allowOrElse(Player damagerPlayer, Player damagedPlayer, boolean silent, Runnable orElse) {
        PvPUser damager = PvPToggle.getInstance().getDataManager().getPvPUser(damagerPlayer);
        PvPUser damaged = PvPToggle.getInstance().getDataManager().getPvPUser(damagedPlayer);
        if (damager == null || damaged == null) {
            return;
        }
        switch (damager.canDamage(damaged)) {
            case ORIGIN_PVP_DISABLED: {
                orElse.run();
                if (silent) break;
                PvPToggle.getInstance().getConfigManager().sendMessage((CommandSender)damagerPlayer, "pvp-disabled");
                break;
            }
            case OTHER_BLOCKED: {
                orElse.run();
                if (silent) break;
                PvPToggle.getInstance().getConfigManager().sendMessage((CommandSender)damagerPlayer, "pvp-blocked");
                break;
            }
            case OTHER_PVP_DISABLED: {
                orElse.run();
                if (silent) break;
                ChatColorHandler.sendMessage((CommandSender)damagerPlayer, PvPToggle.getInstance().getConfigManager().getMessage("pvp-disabled-other").replace("%player%", damagedPlayer.getName()));
                break;
            }
            case ORIGIN_BLOCKED: {
                orElse.run();
                if (silent) break;
                ChatColorHandler.sendMessage((CommandSender)damagerPlayer, PvPToggle.getInstance().getConfigManager().getMessage("pvp-blocked-other").replace("%player%", damagedPlayer.getName()));
                break;
            }
            default: {
                PvPToggle.getInstance().getCooldownManager().setCooldown(damagerPlayer, CooldownManager.CooldownType.PVP);
                PvPToggle.getInstance().getCooldownManager().setCooldown(damagedPlayer, CooldownManager.CooldownType.PVP);
            }
        }
    }

    private void allowOrCancel(Player damagerPlayer, Player damagedPlayer, Cancellable event, boolean silent) {
        this.allowOrElse(damagerPlayer, damagedPlayer, silent, () -> event.setCancelled(true));
    }

    private void allowOrCancel(Player damagerPlayer, Player damagedPlayer, Cancellable event) {
        this.allowOrCancel(damagerPlayer, damagedPlayer, event, false);
    }

    @Nullable
    private PvPUser getPvPUserFromEntity(@NotNull Entity entity) {
        if (entity instanceof Player) {
            Player attackedPlayer = (Player)entity;
            return PvPToggle.getInstance().getDataManager().getPvPUser(attackedPlayer);
        }
        return null;
    }
}

