/*
 * Decompiled with CFR 0.152.
 */
package org.lushplugins.pvptoggle.libraries.pluginupdater.api.util;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import org.lushplugins.pvptoggle.libraries.pluginupdater.api.updater.PluginData;

public class DownloadLogger {
    private static final DateTimeFormatter DATE_TIME_FORMATTER = new DateTimeFormatterBuilder().append(DateTimeFormatter.ISO_LOCAL_DATE).appendLiteral(' ').appendValue(ChronoField.HOUR_OF_DAY, 2).appendLiteral(':').appendValue(ChronoField.MINUTE_OF_HOUR, 2).optionalStart().appendLiteral(':').appendValue(ChronoField.SECOND_OF_MINUTE, 2).toFormatter();
    private static File logFile;

    public static void setLogFile(File file) {
        logFile = file;
    }

    public static void logDownload(PluginData pluginData) {
        if (logFile == null) {
            return;
        }
        try {
            PrintWriter writer = new PrintWriter(new FileWriter(logFile, true));
            writer.print("[" + LocalDateTime.now().format(DATE_TIME_FORMATTER) + "] Downloaded " + pluginData.getPluginName() + ": " + pluginData.getCurrentVersion() + " -> " + pluginData.getLatestVersion() + "\n");
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

