/*
 * Decompiled with CFR 0.152.
 */
package org.lushplugins.chatcolorhandler.messengers;

import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lushplugins.chatcolorhandler.messengers.Messenger;

public abstract class AbstractMessenger
implements Messenger {
    @Override
    public void sendMessage(@NotNull CommandSender recipient, String ... messages) {
        for (String message : messages) {
            this.sendMessage(recipient, message);
        }
    }

    @Override
    public void sendMessage(CommandSender[] recipients, @Nullable String message) {
        for (CommandSender recipient : recipients) {
            this.sendMessage(recipient, message);
        }
    }

    @Override
    public void sendMessage(CommandSender[] recipients, String ... messages) {
        if (messages == null) {
            return;
        }
        for (CommandSender recipient : recipients) {
            for (String message : messages) {
                this.sendMessage(recipient, message);
            }
        }
    }

    @Override
    public void broadcastMessage(String ... messages) {
        if (messages == null) {
            return;
        }
        for (String message : messages) {
            this.broadcastMessage(message);
        }
    }

    @Override
    public void sendActionBarMessage(@NotNull Player[] players, @Nullable String message) {
        if (message == null || message.isBlank()) {
            return;
        }
        for (Player player : players) {
            this.sendActionBarMessage(player, message);
        }
    }

    @Override
    public void sendTitle(@NotNull Player[] players, @Nullable String title) {
        for (Player player : players) {
            this.sendTitle(player, title);
        }
    }

    @Override
    public void sendTitle(@NotNull Player[] players, @Nullable String title, @Nullable String subtitle) {
        for (Player player : players) {
            this.sendTitle(player, title, subtitle);
        }
    }

    @Override
    public void sendTitle(@NotNull Player[] players, @Nullable String title, @Nullable String subtitle, int fadeIn, int fadeOut) {
        for (Player player : players) {
            this.sendTitle(player, title, subtitle, fadeIn, fadeOut);
        }
    }

    @Override
    public void sendTitle(@NotNull Player[] players, @Nullable String title, @Nullable String subtitle, int fadeIn, int stay, int fadeOut) {
        for (Player player : players) {
            this.sendTitle(player, title, subtitle, fadeIn, stay, fadeOut);
        }
    }
}

