/*
 * Decompiled with CFR 0.152.
 */
package org.lushplugins.pvptoggle.libraries.pluginupdater.api.platform.spigot;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import org.lushplugins.pvptoggle.libraries.pluginupdater.api.platform.PlatformData;
import org.lushplugins.pvptoggle.libraries.pluginupdater.api.platform.spigot.SpigotData;
import org.lushplugins.pvptoggle.libraries.pluginupdater.api.updater.PluginData;
import org.lushplugins.pvptoggle.libraries.pluginupdater.api.util.UpdaterConstants;
import org.lushplugins.pvptoggle.libraries.pluginupdater.api.version.VersionChecker;

public class SpigotVersionChecker
implements VersionChecker {
    @Override
    public String getLatestVersion(PluginData pluginData, PlatformData platformData) throws IOException {
        if (!(platformData instanceof SpigotData)) {
            return null;
        }
        SpigotData spigotData = (SpigotData)platformData;
        URL url = new URL("https://api.spiget.org/v2/resources/" + spigotData.getSpigotResourceId() + "/versions/latest");
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.addRequestProperty("User-Agent", "PluginUpdater/" + UpdaterConstants.VERSION);
        if (connection.getResponseCode() != 200) {
            throw new IllegalStateException("Received invalid response code (" + connection.getResponseCode() + ") whilst checking '" + pluginData.getPluginName() + "' for updates.");
        }
        InputStream inputStream = connection.getInputStream();
        InputStreamReader reader = new InputStreamReader(inputStream);
        JsonObject pluginJson = JsonParser.parseReader((Reader)reader).getAsJsonObject();
        return pluginJson.get("name").getAsString();
    }

    @Override
    public String getDownloadUrl(PluginData pluginData, PlatformData platformData) {
        String string;
        if (platformData instanceof SpigotData) {
            SpigotData spigotData = (SpigotData)platformData;
            string = "https://api.spiget.org/v2/resources/" + spigotData.getSpigotResourceId() + "/download";
        } else {
            string = null;
        }
        return string;
    }
}

