/*
 * Decompiled with CFR 0.152.
 */
package org.lushplugins.pvptoggle.libraries.pluginupdater.api.version;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.Bukkit;
import org.lushplugins.pvptoggle.libraries.pluginupdater.api.platform.PlatformData;
import org.lushplugins.pvptoggle.libraries.pluginupdater.api.platform.PlatformRegistry;
import org.lushplugins.pvptoggle.libraries.pluginupdater.api.updater.PluginData;
import org.lushplugins.pvptoggle.libraries.pluginupdater.api.util.DownloadLogger;
import org.lushplugins.pvptoggle.libraries.pluginupdater.api.util.UpdaterConstants;
import org.lushplugins.pvptoggle.libraries.pluginupdater.api.version.VersionDifference;

public interface VersionChecker {
    public static final Pattern VERSION_PATTERN = Pattern.compile("(\\d+(\\.\\d+)+)");

    public String getLatestVersion(PluginData var1, PlatformData var2) throws IOException;

    public String getDownloadUrl(PluginData var1, PlatformData var2) throws IOException;

    default public boolean isUpdateAvailable(PluginData pluginData, PlatformData platformData) throws IOException {
        String currentVersion = pluginData.getCurrentVersion();
        Matcher matcher = VERSION_PATTERN.matcher(this.getLatestVersion(pluginData, platformData));
        if (!matcher.find()) {
            return false;
        }
        String latestVersion = matcher.group();
        pluginData.setCheckRan(true);
        VersionDifference versionDifference = VersionDifference.getVersionDifference(currentVersion, latestVersion);
        if (!versionDifference.equals((Object)VersionDifference.LATEST)) {
            pluginData.setLatestVersion(latestVersion);
            pluginData.setVersionDifference(versionDifference);
            return true;
        }
        return false;
    }

    default public boolean download(PluginData pluginData, PlatformData platformData) throws IOException {
        String pluginName = pluginData.getPluginName();
        String latestVersion = pluginData.getLatestVersion();
        String downloadUrl = this.getDownloadUrl(pluginData, platformData);
        if (downloadUrl == null) {
            return false;
        }
        URL url = new URL(downloadUrl);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.addRequestProperty("User-Agent", "PluginUpdater/" + UpdaterConstants.VERSION);
        connection.setInstanceFollowRedirects(true);
        HttpURLConnection.setFollowRedirects(true);
        if (connection.getResponseCode() != 200) {
            throw new IllegalStateException("Response code was " + connection.getResponseCode());
        }
        Object fileName = url.getFile();
        if (((String)fileName).isEmpty()) {
            fileName = pluginName + "-" + latestVersion + ".jar";
        }
        Bukkit.getUpdateFolderFile().mkdirs();
        ReadableByteChannel rbc = Channels.newChannel(connection.getInputStream());
        File out = new File(Bukkit.getUpdateFolderFile(), (String)fileName);
        UpdaterConstants.LOGGER.info("Saving '" + (String)fileName + "' to '" + out.getAbsolutePath() + "'");
        FileOutputStream fos = new FileOutputStream(out);
        fos.getChannel().transferFrom(rbc, 0L, Long.MAX_VALUE);
        fos.close();
        DownloadLogger.logDownload(pluginData);
        return true;
    }

    public static String getLatestVersion(PluginData pluginData) throws IOException {
        try {
            return VersionChecker.attemptOnPlatforms(pluginData, (versionChecker, platformData) -> versionChecker.getLatestVersion(pluginData, platformData));
        }
        catch (IOException e) {
            throw new IOException("Failed to check plugin '" + pluginData.getPluginName() + "' for latest version.");
        }
    }

    public static String getDownloadUrl(PluginData pluginData) throws IOException {
        try {
            return VersionChecker.attemptOnPlatforms(pluginData, (versionChecker, platformData) -> versionChecker.getDownloadUrl(pluginData, platformData));
        }
        catch (IOException e) {
            throw new IOException("Failed to get download url for plugin '" + pluginData.getPluginName() + "'.");
        }
    }

    public static boolean isUpdateAvailable(PluginData pluginData) throws IOException {
        try {
            return VersionChecker.attemptOnPlatforms(pluginData, (versionChecker, platformData) -> versionChecker.isUpdateAvailable(pluginData, platformData));
        }
        catch (IOException e) {
            throw new IOException("Failed to check if update is available for plugin '" + pluginData.getPluginName() + "'.");
        }
    }

    public static boolean download(PluginData pluginData) throws IOException {
        try {
            return VersionChecker.attemptOnPlatforms(pluginData, (versionChecker, platformData) -> versionChecker.download(pluginData, platformData));
        }
        catch (IOException e) {
            throw new IOException("Failed to download update for plugin '" + pluginData.getPluginName() + "'.");
        }
    }

    private static <T> T attemptOnPlatforms(PluginData pluginData, VersionCheckerCallable<T> callable) throws IOException {
        for (PlatformData platformData : pluginData.getPlatformData()) {
            VersionChecker versionChecker = PlatformRegistry.getVersionChecker(platformData.getName());
            if (versionChecker == null) continue;
            try {
                return callable.call(versionChecker, platformData);
            }
            catch (IOException e) {
                UpdaterConstants.LOGGER.severe(e.getMessage());
            }
        }
        throw new IOException("Failed to all attempts on all available platforms for plugin '" + pluginData.getPluginName() + "'.");
    }

    @FunctionalInterface
    public static interface VersionCheckerCallable<T> {
        public T call(VersionChecker var1, PlatformData var2) throws IOException;
    }
}

