/*
 * Decompiled with CFR 0.152.
 */
package org.lushplugins.chatcolorhandler.messengers;

import java.time.Duration;
import java.util.List;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.kyori.adventure.title.Title;
import net.kyori.adventure.title.TitlePart;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lushplugins.chatcolorhandler.ChatColorHandler;
import org.lushplugins.chatcolorhandler.messengers.AbstractMessenger;
import org.lushplugins.chatcolorhandler.parsers.custom.LegacyCharParser;
import org.lushplugins.chatcolorhandler.parsers.custom.MiniMessageParser;
import org.lushplugins.chatcolorhandler.parsers.custom.PlaceholderAPIParser;
import org.lushplugins.chatcolorhandler.resolvers.Resolvers;

public class MiniMessageMessenger
extends AbstractMessenger {
    private final MiniMessage miniMessage = MiniMessage.miniMessage();

    @Override
    public void sendMessage(@NotNull CommandSender recipient, @Nullable String message) {
        Player player;
        if (message == null || message.isBlank()) {
            return;
        }
        Audience audience = Audience.audience((Audience[])new Audience[]{(Audience)recipient});
        String legacyParsed = MiniMessageParser.legacyToMiniMessage(ChatColorHandler.translate(message, recipient instanceof Player ? (player = (Player)recipient) : null, List.of(LegacyCharParser.class, PlaceholderAPIParser.class)), true);
        Component parsed = this.miniMessage.deserialize(legacyParsed, Resolvers.getResolver(audience, null));
        audience.sendMessage(parsed);
    }

    @Override
    public void broadcastMessage(@Nullable String message) {
        if (message == null || message.isBlank()) {
            return;
        }
        Audience audience = Audience.audience((Audience[])new Audience[]{(Audience)Bukkit.getServer()});
        String legacyParsed = MiniMessageParser.legacyToMiniMessage(ChatColorHandler.translate(message, List.of(LegacyCharParser.class, PlaceholderAPIParser.class)), true);
        audience.sendMessage(this.miniMessage.deserialize(legacyParsed, Resolvers.getResolver(audience, null)));
    }

    @Override
    public void sendActionBarMessage(@NotNull Player player, @Nullable String message) {
        if (message == null || message.isBlank()) {
            return;
        }
        Audience audience = Audience.audience((Audience[])new Audience[]{(Audience)player});
        String legacyParsed = MiniMessageParser.legacyToMiniMessage(ChatColorHandler.translate(message, player, List.of(LegacyCharParser.class, PlaceholderAPIParser.class)), true);
        audience.sendActionBar(this.miniMessage.deserialize(legacyParsed, Resolvers.getResolver(audience, null)));
    }

    @Override
    public void sendTitle(@NotNull Player player, @Nullable String title) {
        if (title == null || title.isBlank()) {
            return;
        }
        this.sendTitle(player, title, null, 10, 70, 20);
    }

    @Override
    public void sendTitle(@NotNull Player player, @Nullable String title, @Nullable String subtitle) {
        this.sendTitle(player, title, subtitle, 10, 70, 20);
    }

    @Override
    public void sendTitle(@NotNull Player player, @Nullable String title, @Nullable String subtitle, int fadeIn, int fadeOut) {
        this.sendTitle(player, title, subtitle, fadeIn, 70, fadeOut);
    }

    @Override
    public void sendTitle(@NotNull Player player, @Nullable String title, @Nullable String subtitle, int fadeIn, int stay, int fadeOut) {
        Audience audience = Audience.audience((Audience[])new Audience[]{(Audience)player});
        TagResolver resolver = Resolvers.getResolver(audience, null);
        Title.Times times = Title.Times.times((Duration)Duration.ofMillis((long)fadeIn * 50L), (Duration)Duration.ofMillis((long)stay * 50L), (Duration)Duration.ofMillis((long)fadeOut * 50L));
        String subtitleLegacyParsed = MiniMessageParser.legacyToMiniMessage(ChatColorHandler.translate(subtitle, player, List.of(LegacyCharParser.class, PlaceholderAPIParser.class)), true);
        String titleLegacyParsed = MiniMessageParser.legacyToMiniMessage(ChatColorHandler.translate(title, player, List.of(LegacyCharParser.class, PlaceholderAPIParser.class)), true);
        audience.sendTitlePart(TitlePart.TIMES, (Object)times);
        audience.sendTitlePart(TitlePart.SUBTITLE, (Object)this.miniMessage.deserialize(subtitleLegacyParsed, resolver));
        audience.sendTitlePart(TitlePart.TITLE, (Object)this.miniMessage.deserialize(titleLegacyParsed, resolver));
    }
}

