/*
 * Decompiled with CFR 0.152.
 */
package org.lushplugins.pvptoggle.listeners;

import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.lushplugins.pvptoggle.PvPToggle;
import org.lushplugins.pvptoggle.hooks.WorldGuardHook;

public class PlayerListener
implements Listener {
    private final Particle.DustOptions dustOptions = new Particle.DustOptions(Color.RED, 1.0f);

    public PlayerListener() {
        PvPToggle plugin = PvPToggle.getInstance();
        for (Player player : Bukkit.getOnlinePlayers()) {
            PvPToggle.getInstance().getDataManager().loadPvPUser(player).thenAccept(ignored -> Bukkit.getScheduler().runTask((Plugin)plugin, () -> this.checkPvPWorld(player)));
        }
        Bukkit.getScheduler().runTaskTimer((Plugin)PvPToggle.getInstance(), () -> {
            HashSet<UUID> pvpEnabledPlayers = PvPToggle.getInstance().getDataManager().getPvPEnabledPlayers();
            for (UUID playerUUID : pvpEnabledPlayers) {
                Player player = Bukkit.getPlayer((UUID)playerUUID);
                if (player != null) {
                    this.displayParticles(player);
                    continue;
                }
                PvPToggle.getInstance().getDataManager().removePvPEnabledPlayer(playerUUID);
            }
        }, 0L, 4L);
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        PvPToggle.getInstance().getDataManager().loadPvPUser(player).thenAccept(pvpUser -> Bukkit.getScheduler().runTask((Plugin)PvPToggle.getInstance(), () -> {
            pvpUser.setUsername(player.getName());
            this.checkPvPWorld(player);
        }));
    }

    @EventHandler
    public void onPlayerLeave(PlayerQuitEvent event) {
        UUID playerUUID = event.getPlayer().getUniqueId();
        PvPToggle.getInstance().getDataManager().unloadPvPUser(playerUUID);
    }

    @EventHandler
    public void onChangeWorld(PlayerChangedWorldEvent event) {
        Player player = event.getPlayer();
        this.checkPvPWorld(player);
    }

    @EventHandler
    public void onPlayerMove(PlayerMoveEvent event) {
        Player player;
        WorldGuardHook worldGuardHook;
        if (PvPToggle.getInstance().getConfigManager().isWorldIgnored(event.getPlayer().getWorld().getName())) {
            return;
        }
        if (event.getTo() == null || event.getFrom().getBlock().equals((Object)event.getTo().getBlock())) {
            return;
        }
        Object var3_2 = PvPToggle.getInstance().getHook("WorldGuard").orElse(null);
        if (var3_2 instanceof WorldGuardHook && (worldGuardHook = (WorldGuardHook)var3_2).isRegionEnabled((player = event.getPlayer()).getWorld(), event.getFrom()) != worldGuardHook.isRegionEnabled(player.getWorld(), event.getTo())) {
            Bukkit.getScheduler().runTaskLater((Plugin)PvPToggle.getInstance(), () -> worldGuardHook.checkPvPRegion(player), 1L);
        }
    }

    private void checkPvPWorld(@NotNull Player player) {
        World world = player.getWorld();
        boolean playerHasPvPEnabled = PvPToggle.getInstance().getDataManager().getPvPUser(player).isPvPEnabled();
        if (!world.getPVP() && !playerHasPvPEnabled) {
            PvPToggle.getInstance().getConfigManager().sendMessage((CommandSender)player, "pvp-world-change-disabled");
            return;
        }
        if (PvPToggle.getInstance().getConfigManager().isWorldIgnored(world.getName()) && world.getPVP() && playerHasPvPEnabled) {
            PvPToggle.getInstance().getConfigManager().sendMessage((CommandSender)player, "pvp-world-change-required");
        }
    }

    private void displayParticles(@NotNull Player player) {
        int particlesMode = PvPToggle.getInstance().getConfigManager().getParticlesDisplayMode();
        switch (particlesMode) {
            case 0: {
                player.getWorld().spawnParticle(Particle.DUST, player.getEyeLocation().add(0.0, 0.5, 0.0), 0, 0.0, 1.0, 0.0, (Object)this.dustOptions);
                break;
            }
            case 1: {
                Location pLoc = player.getLocation();
                HashSet<UUID> pvpEnabledPlayers = PvPToggle.getInstance().getDataManager().getPvPEnabledPlayers();
                List nearbyEntities = player.getNearbyEntities(pLoc.getX(), pLoc.getY(), pLoc.getZ());
                for (Entity entity : nearbyEntities) {
                    Player nearbyPlayer;
                    if (!(entity instanceof Player) || !pvpEnabledPlayers.contains((nearbyPlayer = (Player)entity).getUniqueId())) continue;
                    nearbyPlayer.spawnParticle(Particle.DUST, player.getEyeLocation().add(0.0, 0.5, 0.0), 0, 0.0, 1.0, 0.0, (Object)this.dustOptions);
                }
                break;
            }
        }
    }
}

