/*
 * Decompiled with CFR 0.152.
 */
package org.lushplugins.chatcolorhandler;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.PluginManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lushplugins.chatcolorhandler.ModernChatColorHandler;
import org.lushplugins.chatcolorhandler.messengers.LegacyMessenger;
import org.lushplugins.chatcolorhandler.messengers.Messenger;
import org.lushplugins.chatcolorhandler.messengers.MiniMessageMessenger;
import org.lushplugins.chatcolorhandler.parsers.Parsers;
import org.lushplugins.chatcolorhandler.parsers.custom.HexParser;
import org.lushplugins.chatcolorhandler.parsers.custom.LegacyCharParser;
import org.lushplugins.chatcolorhandler.parsers.custom.MiniMessageParser;
import org.lushplugins.chatcolorhandler.parsers.custom.Parser;
import org.lushplugins.chatcolorhandler.parsers.custom.PlaceholderAPIParser;
import org.lushplugins.chatcolorhandler.resolvers.MiniPlaceholdersResolver;
import org.lushplugins.chatcolorhandler.resolvers.Resolvers;

public class ChatColorHandler {
    private static final String LOGGER_PREFIX = "[ChatColorHandler] ";
    private static final Pattern HEX_PATTERN = Pattern.compile("&#[a-fA-F0-9]{6}");
    private static Messenger messenger;
    private static ModernChatColorHandler modernHandler;

    protected static Messenger getMessenger() {
        return messenger;
    }

    public static void sendMessage(@NotNull CommandSender recipient, @Nullable String message) {
        messenger.sendMessage(recipient, message);
    }

    public static void sendMessage(@NotNull CommandSender recipient, String ... messages) {
        messenger.sendMessage(recipient, messages);
    }

    public static void sendMessage(CommandSender[] recipients, @Nullable String message) {
        messenger.sendMessage(recipients, message);
    }

    public static void sendMessage(CommandSender[] recipients, String ... messages) {
        messenger.sendMessage(recipients, messages);
    }

    public static void broadcastMessage(@Nullable String message) {
        messenger.broadcastMessage(message);
    }

    public static void broadcastMessage(String ... messages) {
        messenger.broadcastMessage(messages);
    }

    public static void sendActionBarMessage(@NotNull Player player, @Nullable String message) {
        messenger.sendActionBarMessage(player, message);
    }

    public static void sendActionBarMessage(@NotNull Player[] players, @Nullable String message) {
        messenger.sendActionBarMessage(players, message);
    }

    public static void sendTitle(@NotNull Player player, @Nullable String title) {
        messenger.sendTitle(player, title);
    }

    public static void sendTitle(@NotNull Player player, @Nullable String title, @Nullable String subtitle) {
        messenger.sendTitle(player, title, subtitle);
    }

    public static void sendTitle(@NotNull Player player, @Nullable String title, @Nullable String subtitle, int fadeIn, int fadeOut) {
        messenger.sendTitle(player, title, subtitle, fadeIn, fadeOut);
    }

    public static void sendTitle(@NotNull Player player, @Nullable String title, @Nullable String subtitle, int fadeIn, int stay, int fadeOut) {
        messenger.sendTitle(player, title, subtitle, fadeIn, stay, fadeOut);
    }

    public static void sendTitle(@NotNull Player[] players, @Nullable String title) {
        messenger.sendTitle(players, title);
    }

    public static void sendTitle(@NotNull Player[] players, @Nullable String title, @Nullable String subtitle) {
        messenger.sendTitle(players, title, subtitle);
    }

    public static void sendTitle(@NotNull Player[] players, @Nullable String title, @Nullable String subtitle, int fadeIn, int fadeOut) {
        messenger.sendTitle(players, title, subtitle, fadeIn, fadeOut);
    }

    public static void sendTitle(@NotNull Player[] players, @Nullable String title, @Nullable String subtitle, int fadeIn, int stay, int fadeOut) {
        messenger.sendTitle(players, title, subtitle, fadeIn, stay, fadeOut);
    }

    public static String translate(@Nullable String string) {
        return ChatColorHandler.translate(string, null, null);
    }

    public static String translate(@Nullable String string, List<Class<? extends Parser>> parsers) {
        if (string == null || string.isBlank()) {
            return "";
        }
        return Parsers.parseString(string, null, parsers);
    }

    public static String translate(@Nullable String string, Player player) {
        return ChatColorHandler.translate(string, player, null);
    }

    public static String translate(@Nullable String string, Player player, List<Class<? extends Parser>> parsers) {
        if (string == null || string.isBlank()) {
            return "";
        }
        return Parsers.parseString(string, player, parsers);
    }

    public static List<String> translate(@NotNull Collection<String> strings) {
        return strings.stream().map(ChatColorHandler::translate).toList();
    }

    public static List<String> translate(@NotNull Collection<String> strings, List<Class<? extends Parser>> parsers) {
        return strings.stream().map(string -> ChatColorHandler.translate(string, parsers)).toList();
    }

    public static List<String> translate(@NotNull Collection<String> strings, Player player) {
        return strings.stream().map(string -> ChatColorHandler.translate(string, player)).toList();
    }

    public static List<String> translate(@NotNull Collection<String> strings, Player player, List<Class<? extends Parser>> parsers) {
        return strings.stream().map(string -> ChatColorHandler.translate(string, player, parsers)).toList();
    }

    @Deprecated(forRemoval=true)
    public static String translateAlternateColorCodes(@Nullable String string) {
        return ChatColorHandler.translate(string);
    }

    @Deprecated(forRemoval=true)
    public static String translateAlternateColorCodes(@Nullable String string, List<Class<? extends Parser>> parsers) {
        return ChatColorHandler.translate(string, parsers);
    }

    @Deprecated(forRemoval=true)
    public static String translateAlternateColorCodes(@Nullable String string, Player player) {
        return ChatColorHandler.translate(string, player);
    }

    @Deprecated(forRemoval=true)
    public static String translateAlternateColorCodes(@Nullable String string, Player player, List<Class<? extends Parser>> parsers) {
        return ChatColorHandler.translate(string, player, parsers);
    }

    @Deprecated(forRemoval=true)
    public static List<String> translateAlternateColorCodes(@Nullable List<String> strings) {
        return ChatColorHandler.translateAlternateColorCodes(strings, null, null);
    }

    @Deprecated(forRemoval=true)
    public static List<String> translateAlternateColorCodes(@Nullable List<String> strings, List<Class<? extends Parser>> parsers) {
        return ChatColorHandler.translateAlternateColorCodes(strings, null, parsers);
    }

    @Deprecated(forRemoval=true)
    public static List<String> translateAlternateColorCodes(@Nullable List<String> strings, Player player) {
        return ChatColorHandler.translateAlternateColorCodes(strings, player, null);
    }

    @Deprecated(forRemoval=true)
    public static List<String> translateAlternateColorCodes(@Nullable List<String> strings, Player player, List<Class<? extends Parser>> parsers) {
        if (strings == null || strings.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> outputList = new ArrayList<String>();
        for (String string : strings) {
            outputList.add(ChatColorHandler.translate(string, player, parsers));
        }
        return outputList;
    }

    public static String stripColor(@Nullable String string) {
        if (string == null || string.isBlank()) {
            return "";
        }
        string = string.replace("\u00a7", "&");
        Matcher match = HEX_PATTERN.matcher(string);
        while (match.find()) {
            String color = string.substring(match.start() + 1, match.end());
            string = string.replace("&" + color, "" + ChatColor.of((String)color));
            match = HEX_PATTERN.matcher(string);
        }
        return ChatColor.stripColor((String)ChatColor.translateAlternateColorCodes((char)'&', (String)string));
    }

    public static List<String> stripColor(@Nullable List<String> strings) {
        if (strings == null || strings.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> outputList = new ArrayList<String>();
        for (String string : strings) {
            outputList.add(ChatColorHandler.stripColor(string));
        }
        return outputList;
    }

    static {
        Parsers.register(new LegacyCharParser(), 100);
        Parsers.register(new HexParser(), 70);
        try {
            Class.forName("net.kyori.adventure.text.minimessage.MiniMessage").getMethod("miniMessage", new Class[0]);
            Parsers.register(new MiniMessageParser(), 80);
            messenger = new MiniMessageMessenger();
            Bukkit.getLogger().info("[ChatColorHandler] Found MiniMessage in Server. MiniMessage support enabled.");
        }
        catch (ClassNotFoundException | NoSuchMethodException ignored) {
            messenger = new LegacyMessenger();
            Bukkit.getLogger().info("[ChatColorHandler] Unable to find MiniMessage. MiniMessage support not enabled.");
        }
        PluginManager pluginManager = Bukkit.getServer().getPluginManager();
        if (pluginManager.getPlugin("PlaceholderAPI") != null && pluginManager.isPluginEnabled("PlaceholderAPI")) {
            Parsers.register(new PlaceholderAPIParser(), 90);
            Bukkit.getLogger().info("[ChatColorHandler] Found plugin \"PlaceholderAPI\". PlaceholderAPI support enabled.");
        }
        if (pluginManager.getPlugin("MiniPlaceholders") != null && pluginManager.isPluginEnabled("MiniPlaceholders")) {
            Resolvers.register(new MiniPlaceholdersResolver());
            Bukkit.getLogger().info("[ChatColorHandler] Found plugin \"MiniPlaceholders\". MiniPlaceholders support enabled.");
        }
    }
}

